/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.source.TrimFieldsSelection;
import com.atlassian.braid.source.VariableNamespacingGraphQLQueryVisitor;
import com.atlassian.braid.transformation.FieldWithCounter;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

class QueryTransformationUtils {
    QueryTransformationUtils() {
    }

    static OperationDefinition getOperationDefinition(DataFetchingEnvironment environment) {
        return environment.getExecutionContext().getOperationDefinition();
    }

    static FieldWithCounter cloneTrimAndAliasField(FieldTransformationContext fieldTransformationContext, List<Integer> usedCounterIds, DataFetchingEnvironment environment, boolean dontTrimFirstField) {
        Field field = environment.getField().deepCopy();
        field.setAlias(field.getName() + fieldTransformationContext.getCounter().incrementAndGet());
        usedCounterIds.add(fieldTransformationContext.getCounter().get());
        List<FragmentDefinition> referencedFragments = TrimFieldsSelection.trimFieldSelection(fieldTransformationContext.getSchemaSource(), environment, (Node)field, dontTrimFirstField);
        return new FieldWithCounter(field, fieldTransformationContext.getCounter().get(), referencedFragments);
    }

    static void addFieldToQuery(FieldTransformationContext fieldTransformationContext, DataFetchingEnvironment environment, OperationDefinition operationDefinition, FieldWithCounter field) {
        VariableNamespacingGraphQLQueryVisitor variableNameSpacer = new VariableNamespacingGraphQLQueryVisitor(field.counter, operationDefinition, fieldTransformationContext.getVariables(), environment, fieldTransformationContext.getQueryOp());
        field.referencedFragments.forEach(arg_0 -> QueryTransformationUtils.lambda$addFieldToQuery$0((NodeVisitor)variableNameSpacer, fieldTransformationContext, arg_0));
        NodeTraverser nodeTraverser = new NodeTraverser();
        nodeTraverser.preOrder((NodeVisitor)variableNameSpacer, (Node)field.field);
        fieldTransformationContext.getQueryOp().getSelectionSet().getSelections().add(field.field);
        List<VariableDefinition> uniqueVariableDefs = QueryTransformationUtils.getUniqueVariableDefs(fieldTransformationContext.getQueryOp().getVariableDefinitions());
        fieldTransformationContext.getQueryOp().getVariableDefinitions().clear();
        fieldTransformationContext.getQueryOp().getVariableDefinitions().addAll(uniqueVariableDefs);
    }

    private static List<VariableDefinition> getUniqueVariableDefs(List<VariableDefinition> variables) {
        HashSet<String> uniqueVarSet = new HashSet<String>();
        ArrayList<VariableDefinition> uniqueVarDefs = new ArrayList<VariableDefinition>();
        for (VariableDefinition variable : variables) {
            if (uniqueVarSet.contains(variable.getName())) continue;
            uniqueVarSet.add(variable.getName());
            uniqueVarDefs.add(variable);
        }
        return uniqueVarDefs;
    }

    private static /* synthetic */ void lambda$addFieldToQuery$0(NodeVisitor variableNameSpacer, FieldTransformationContext fieldTransformationContext, FragmentDefinition d) {
        NodeTraverser nodeTraverser = new NodeTraverser();
        nodeTraverser.preOrder(variableNameSpacer, (Node)d);
        fieldTransformationContext.addFragmentDefinition(d);
    }
}

