/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldRename;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeRename;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.transformation.BraidTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraidSchemaSource {
    private static final Logger log = LoggerFactory.getLogger(BraidSchemaSource.class);
    private final SchemaSource schemaSource;
    private final TypeDefinitionRegistry registry;
    private final ObjectTypeDefinition queryType;
    private final ObjectTypeDefinition mutationType;

    public BraidSchemaSource(SchemaSource schemaSource) {
        this.schemaSource = Objects.requireNonNull(schemaSource);
        this.registry = schemaSource.getSchema();
        this.queryType = TypeUtils.findQueryType(this.registry).orElse(null);
        this.mutationType = TypeUtils.findMutationType(this.registry).orElse(null);
    }

    public SchemaSource getSchemaSource() {
        return this.schemaSource;
    }

    public SchemaNamespace getNamespace() {
        return this.schemaSource.getNamespace();
    }

    List<Extension> getExtensions(String type) {
        return this.schemaSource.getExtensions().stream().filter(e -> e.getType().equals(type)).collect(Collectors.toList());
    }

    Optional<TypeRename> getTypeRenameFromSourceName(String type) {
        return this.schemaSource.getTypeRenames().stream().filter(a -> a.getSourceName().equals(type)).findFirst();
    }

    public Optional<TypeRename> getTypeRenameFromBraidName(String type) {
        return this.schemaSource.getTypeRenames().stream().filter(a -> a.getBraidName().equals(type)).findFirst();
    }

    public String getBraidTypeName(String sourceTypeName) {
        return this.getTypeRenameFromSourceName(sourceTypeName).map(TypeRename::getBraidName).orElse(sourceTypeName);
    }

    public String getSourceTypeName(String braidTypeName) {
        return this.getTypeRenameFromBraidName(braidTypeName).map(TypeRename::getSourceName).orElse(braidTypeName);
    }

    Optional<FieldRename> getQueryFieldRenames(String sourceFieldName) {
        return this.getFieldRenameBySourceName(this.schemaSource.getQueryFieldRenames(), sourceFieldName);
    }

    Optional<FieldRename> getMutationFieldRenames(String sourceFieldName) {
        return this.getFieldRenameBySourceName(this.schemaSource.getMutationFieldRenames(), sourceFieldName);
    }

    public String getOperationNamePrefix() {
        return this.schemaSource.getOperationNamePrefix();
    }

    public String getLinkBraidSourceType(Link link) {
        return this.getQueryType().flatMap(this.maybeGetQueryTypeNameIfLinkSourceIsQueryType(link)).orElseGet(link::getSourceType);
    }

    private Function<ObjectTypeDefinition, Optional<String>> maybeGetQueryTypeNameIfLinkSourceIsQueryType(Link link) {
        return originalQueryType -> this.isLinkSourceTypeQueryType(link, (ObjectTypeDefinition)originalQueryType) ? Optional.of("Query") : Optional.empty();
    }

    private boolean isLinkSourceTypeQueryType(Link link, ObjectTypeDefinition originalQueryType) {
        return originalQueryType.getName().equals(link.getSourceType());
    }

    public Collection<BraidTypeDefinition> getNonOperationTypes() {
        return this.registry.types().values().stream().filter(this::isNotOperationType).map(td -> new BraidTypeDefinition(this, (TypeDefinition)td)).collect(Collectors.toList());
    }

    boolean hasType(String type) {
        return this.getType(type).isPresent();
    }

    Optional<TypeDefinition> getType(String type) {
        return this.registry.getType(type);
    }

    Optional<ObjectTypeDefinition> getQueryType() {
        return Optional.ofNullable(this.queryType);
    }

    Optional<ObjectTypeDefinition> getMutationType() {
        return Optional.ofNullable(this.mutationType);
    }

    public TypeDefinitionRegistry getTypeRegistry() {
        return this.registry;
    }

    Type renameTypeToBraidName(Type type) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            TypeRename typeRename = this.getTypeRenameFromSourceName(typeName).orElse(TypeRename.from(typeName, typeName));
            return new TypeName(typeRename.getBraidName());
        }
        if (type instanceof NonNullType) {
            return new NonNullType(this.renameTypeToBraidName(((NonNullType)type).getType()));
        }
        if (type instanceof ListType) {
            return new ListType(this.renameTypeToBraidName(((ListType)type).getType()));
        }
        log.error("Definition type : " + type + " not handled correctly for aliases.  Please raise an issue.");
        return type;
    }

    public Type renameTypeToSourceName(Type type) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            TypeRename alias = this.getTypeRenameFromBraidName(typeName).orElse(TypeRename.from(typeName, typeName));
            return new TypeName(alias.getSourceName());
        }
        if (type instanceof NonNullType) {
            return new NonNullType(this.renameTypeToSourceName(((NonNullType)type).getType()));
        }
        if (type instanceof ListType) {
            return new ListType(this.renameTypeToSourceName(((ListType)type).getType()));
        }
        log.error("Definition type : " + type + " not handled correctly for aliases.  Please raise an issue.");
        return type;
    }

    List<InputValueDefinition> renameInputValueDefinitionsToBraidTypes(List<InputValueDefinition> inputValueDefinitions) {
        return inputValueDefinitions.stream().map(input -> InputValueDefinition.newInputValueDefinition().name(input.getName()).type(this.renameTypeToBraidName(input.getType())).defaultValue(input.getDefaultValue()).directives(input.getDirectives()).build()).collect(Collectors.toList());
    }

    private Optional<FieldRename> getFieldRenameBySourceName(List<FieldRename> fieldRenames, String sourceName) {
        return fieldRenames.stream().filter(a -> a.getSourceName().equals(sourceName)).findFirst();
    }

    private Optional<FieldRename> getFieldRenameByBraidName(List<FieldRename> fieldRenames, String braidFieldName) {
        return fieldRenames.stream().filter(a -> a.getBraidName().equals(braidFieldName)).findFirst();
    }

    private boolean isNotOperationType(TypeDefinition typeDefinition) {
        return !this.isOperationType(typeDefinition);
    }

    private boolean isOperationType(TypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        return Objects.equals(this.queryType, typeDefinition) || Objects.equals(this.mutationType, typeDefinition);
    }

    boolean hasTypeAndField(TypeDefinitionRegistry registry, TypeDefinition typeDef, FieldDefinition fieldDef) {
        if (TypeUtils.findQueryType(registry).map(qType -> qType == typeDef).orElse(false).booleanValue()) {
            if (this.schemaSource.getQueryFieldRenames().isEmpty()) {
                if (this.queryType == null) {
                    return false;
                }
                return this.queryType.getFieldDefinitions().stream().anyMatch(fieldDefinition -> fieldDefinition.getName().equals(fieldDef.getName()));
            }
            return this.getFieldRenameByBraidName(this.schemaSource.getQueryFieldRenames(), fieldDef.getName()).map(alias -> alias.getBraidName().equals(fieldDef.getName())).orElse(false);
        }
        return this.getType(this.getSourceTypeName(typeDef.getName())).isPresent();
    }
}

