/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.ArgumentValueProvider;
import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.FieldKey;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.LinkUtils;
import com.atlassian.braid.java.util.BraidFutures;
import com.atlassian.braid.transformation.FieldWithCounter;
import com.atlassian.braid.transformation.QueryTransformationUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class LinkTransformation
implements FieldTransformation {
    private final Link link;

    LinkTransformation(Link link) {
        this.link = Objects.requireNonNull(link);
    }

    public Link getLink() {
        return this.link;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        Field cloneOfCurrentField = environment.getField().deepCopy();
        List selections = cloneOfCurrentField.getSelectionSet().getSelections();
        Set<String> shortCircuitFields = LinkTransformation.selectFieldsForShortCircuit(selections, this.link);
        if (this.link.isSimpleLink()) {
            return BatchLoaderUtils.getTargetIdsFromEnvironment(this.link.getSourceInputFieldName(), environment).thenCompose(targetIds -> {
                CompletableFuture[] futureFields = (CompletableFuture[])targetIds.stream().map(targetId -> this.transformSimpleLink(targetId, context, environment, shortCircuitFields)).toArray(CompletableFuture[]::new);
                return BraidFutures.all(Collectors.toList(), futureFields);
            });
        }
        return this.transformComplexLink(context, environment, shortCircuitFields);
    }

    private CompletableFuture<Field> transformSimpleLink(Object argumentValue, FieldTransformationContext context, DataFetchingEnvironment environment, Set<String> shortCircuitFields) {
        FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, new ArrayList<Integer>(), environment, true);
        CompletableFuture<List<LinkUtils.ResolvedArgument>> args = LinkUtils.resolveArgumentsForLink(this.link, context.getSchemaSource(), environment, ArgumentValueProvider.staticArgumentValue(argumentValue), field.counter);
        return args.thenApply(resolvedArguments -> this.createFieldForSelection(field, environment, context, shortCircuitFields, (List<LinkUtils.ResolvedArgument>)resolvedArguments));
    }

    private CompletableFuture<List<Field>> transformComplexLink(FieldTransformationContext context, DataFetchingEnvironment environment, Set<String> shortCircuitFields) {
        FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, new ArrayList<Integer>(), environment, true);
        CompletableFuture<List<LinkUtils.ResolvedArgument>> args = LinkUtils.resolveArgumentsForLink(this.link, context.getSchemaSource(), environment, this.link.getArgumentValueProvider(), field.counter);
        return args.thenApply(resolvedArguments -> Collections.singletonList(this.createFieldForSelection(field, environment, context, shortCircuitFields, (List<LinkUtils.ResolvedArgument>)resolvedArguments)));
    }

    private Field createFieldForSelection(FieldWithCounter field, DataFetchingEnvironment environment, FieldTransformationContext context, Set<String> shortCircuitFields, List<LinkUtils.ResolvedArgument> resolvedArguments) {
        if (!LinkTransformation.areAllArgumentsValuesAllowed(resolvedArguments)) {
            context.getShortCircuitedData().put(new FieldKey(field.field.getAlias()), null);
        } else if (shortCircuitFields != null) {
            Map<String, Object> result = resolvedArguments.stream().filter(arg -> shortCircuitFields.contains(arg.getLinkArgument().getTargetFieldMatchingArgument())).collect(Collectors.toMap(arg -> arg.getLinkArgument().getTargetFieldMatchingArgument(), LinkUtils.ResolvedArgument::getValue));
            context.getShortCircuitedData().put(new FieldKey(field.field.getAlias()), result);
        } else {
            OperationDefinition operationDefinition = QueryTransformationUtils.getOperationDefinition(environment);
            this.createQueryField(context, field, resolvedArguments);
            QueryTransformationUtils.addFieldToQuery(context, environment, operationDefinition, field);
        }
        return field.field;
    }

    private void createQueryField(FieldTransformationContext fieldTransformationContext, FieldWithCounter field, List<LinkUtils.ResolvedArgument> resolvedArguments) {
        if (this.link.getCustomTransformation() != null) {
            this.link.getCustomTransformation().createQuery(field.field, null);
            return;
        }
        field.field.setName(this.link.getTopLevelQueryField());
        ArrayList<Argument> fieldArguments = new ArrayList<Argument>(resolvedArguments.size());
        List variableDefinitions = fieldTransformationContext.getQueryOp().getVariableDefinitions();
        for (LinkUtils.ResolvedArgument resolvedArgument : resolvedArguments) {
            variableDefinitions.add(resolvedArgument.getVariableDefinition());
            fieldArguments.add(resolvedArgument.getArgument());
            fieldTransformationContext.getVariables().put(resolvedArgument.getVariableDefinition().getName(), resolvedArgument.getValue());
        }
        field.field.setArguments(fieldArguments);
    }

    private static boolean areAllArgumentsValuesAllowed(List<LinkUtils.ResolvedArgument> resolvedArguments) {
        return resolvedArguments.stream().noneMatch(arg -> arg.getValue() == null && !arg.getLinkArgument().isNullable());
    }

    private static Set<String> selectFieldsForShortCircuit(List<Selection> selections, Link link) {
        HashSet<String> selectionFields = new HashSet<String>();
        for (Selection selection : selections) {
            if (!(selection instanceof Field)) {
                return null;
            }
            String fieldName = ((Field)selection).getName();
            if (!link.isFieldMatchingArgument(fieldName)) {
                return null;
            }
            selectionFields.add(fieldName);
        }
        return selectionFields;
    }

    @Override
    public DataFetcherResult<Object> unapply(DataFetchingEnvironment environment, DataFetcherResult<Object> dataFetcherResult) {
        if (this.link.getCustomTransformation() != null) {
            return this.link.getCustomTransformation().unapplyForResult(environment.getField(), dataFetcherResult);
        }
        return dataFetcherResult;
    }
}

