/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.SchemaNamespace;
import graphql.execution.DataFetcherResult;
import graphql.language.Field;
import java.util.Objects;
import java.util.Optional;

public final class Link {
    private final SchemaNamespace sourceNamespace;
    private final String sourceType;
    private final SchemaNamespace targetNamespace;
    private final String targetType;
    private final String newFieldName;
    private final String topLevelQueryField;
    private final String queryArgumentName;
    private final String sourceInputFieldName;
    private final String targetFieldMatchingQueryArgument;
    private final boolean removeInputField;
    private final boolean nullable;
    private final boolean noSchemaChangeNeeded;
    private final CustomTransformation customTransformation;

    public Link(SchemaNamespace sourceNamespace, String sourceType, SchemaNamespace targetNamespace, String targetType, String newFieldName, String topLevelQueryField, String queryArgumentName, String sourceInputFieldName, String targetFieldMatchingQueryArgument, boolean removeInputField, boolean nullable, boolean noSchemaChangeNeeded, CustomTransformation customTransformation) {
        this.sourceNamespace = Objects.requireNonNull(sourceNamespace);
        this.sourceType = Objects.requireNonNull(sourceType);
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
        this.targetType = Objects.requireNonNull(targetType);
        this.newFieldName = Objects.requireNonNull(newFieldName);
        this.topLevelQueryField = Objects.requireNonNull(topLevelQueryField);
        this.queryArgumentName = Objects.requireNonNull(queryArgumentName);
        this.sourceInputFieldName = Objects.requireNonNull(sourceInputFieldName);
        this.targetFieldMatchingQueryArgument = Objects.requireNonNull(targetFieldMatchingQueryArgument);
        this.removeInputField = removeInputField;
        this.nullable = nullable;
        this.noSchemaChangeNeeded = noSchemaChangeNeeded;
        this.customTransformation = customTransformation;
    }

    @Deprecated
    public static LinkBuilder from(SchemaNamespace sourceNamespace, String sourceType, String newFieldName) {
        return Link.newLink().sourceNamespace(sourceNamespace).sourceType(sourceType).newFieldName(newFieldName);
    }

    @Deprecated
    public static LinkBuilder from(SchemaNamespace sourceNamespace, String sourceType, String newFieldName, String sourceInputFieldName) {
        return Link.newLink().sourceNamespace(sourceNamespace).sourceType(sourceType).newFieldName(newFieldName).sourceInputFieldName(sourceInputFieldName);
    }

    public String getSourceType() {
        return this.sourceType;
    }

    @Deprecated
    public String getSourceField() {
        return this.newFieldName;
    }

    @Deprecated
    public String getSourceFromField() {
        return this.sourceInputFieldName;
    }

    @Deprecated
    public boolean isReplaceFromField() {
        return this.removeInputField;
    }

    public SchemaNamespace getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getTargetType() {
        return this.targetType;
    }

    @Deprecated
    public String getTargetQueryField() {
        return this.topLevelQueryField;
    }

    @Deprecated
    public String getTargetVariableQueryField() {
        return this.targetFieldMatchingQueryArgument;
    }

    @Deprecated
    public String getArgumentName() {
        return this.queryArgumentName;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public SchemaNamespace getSourceNamespace() {
        return this.sourceNamespace;
    }

    public String getNewFieldName() {
        return this.newFieldName;
    }

    public String getTopLevelQueryField() {
        return this.topLevelQueryField;
    }

    public String getQueryArgumentName() {
        return this.queryArgumentName;
    }

    public String getSourceInputFieldName() {
        return this.sourceInputFieldName;
    }

    public String getTargetFieldMatchingQueryArgument() {
        return this.targetFieldMatchingQueryArgument;
    }

    public boolean isRemoveInputField() {
        return this.removeInputField;
    }

    public boolean isNoSchemaChangeNeeded() {
        return this.noSchemaChangeNeeded;
    }

    public CustomTransformation getCustomTransformation() {
        return this.customTransformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return this.removeInputField == link.removeInputField && this.nullable == link.nullable && Objects.equals(this.sourceNamespace, link.sourceNamespace) && Objects.equals(this.sourceType, link.sourceType) && Objects.equals(this.targetNamespace, link.targetNamespace) && Objects.equals(this.targetType, link.targetType) && Objects.equals(this.newFieldName, link.newFieldName) && Objects.equals(this.topLevelQueryField, link.topLevelQueryField) && Objects.equals(this.queryArgumentName, link.queryArgumentName) && Objects.equals(this.sourceInputFieldName, link.sourceInputFieldName) && Objects.equals(this.targetFieldMatchingQueryArgument, link.targetFieldMatchingQueryArgument);
    }

    public int hashCode() {
        return Objects.hash(this.sourceNamespace, this.sourceType, this.targetNamespace, this.targetType, this.newFieldName, this.topLevelQueryField, this.queryArgumentName, this.sourceInputFieldName, this.targetFieldMatchingQueryArgument, this.removeInputField, this.nullable);
    }

    public String toString() {
        return "Link{sourceNamespace=" + this.sourceNamespace + ", sourceType='" + this.sourceType + '\'' + ", targetNamespace=" + this.targetNamespace + ", targetType='" + this.targetType + '\'' + ", newFieldName='" + this.newFieldName + '\'' + ", topLevelQueryField='" + this.topLevelQueryField + '\'' + ", queryArgumentName='" + this.queryArgumentName + '\'' + ", sourceInputFieldName='" + this.sourceInputFieldName + '\'' + ", targetFieldMatchingQueryArgument='" + this.targetFieldMatchingQueryArgument + '\'' + ", replaceInputField=" + this.removeInputField + ", nullable=" + this.nullable + '}';
    }

    public static LinkBuilder newLink() {
        return new LinkBuilder();
    }

    public static final class LinkBuilder {
        private SchemaNamespace targetNamespace;
        private String targetType;
        private String topLevelQueryField;
        private String queryArgumentName;
        private String sourceInputFieldName;
        private String targetFieldMatchingQueryArgument;
        private boolean removeInputField;
        private SchemaNamespace sourceNamespace;
        private String sourceType;
        private String newFieldName;
        private boolean nullable;
        private boolean noSchemeChangeNeeded;
        private CustomTransformation customTransformation;

        private LinkBuilder() {
        }

        @Deprecated
        public LinkBuilder to(SchemaNamespace targetNamespace, String targetType) {
            return this.to(targetNamespace, targetType, null);
        }

        @Deprecated
        public LinkBuilder to(SchemaNamespace targetNamespace, String targetType, String topLevelQueryField) {
            return this.to(targetNamespace, targetType, topLevelQueryField, null);
        }

        @Deprecated
        public LinkBuilder to(SchemaNamespace targetNamespace, String targetType, String topLevelQueryField, String targetFieldMatchingQueryArgument) {
            this.targetNamespace = targetNamespace;
            this.targetType = targetType;
            this.topLevelQueryField = topLevelQueryField;
            this.targetFieldMatchingQueryArgument = targetFieldMatchingQueryArgument;
            return this;
        }

        public LinkBuilder removeInputField(boolean removeInputField) {
            this.removeInputField = removeInputField;
            return this;
        }

        @Deprecated
        public LinkBuilder replaceFromField() {
            return this.removeInputField(true);
        }

        @Deprecated
        public LinkBuilder argument(String queryArgumentName) {
            return this.queryArgumentName(queryArgumentName);
        }

        public LinkBuilder queryArgumentName(String queryArgumentName) {
            this.queryArgumentName = queryArgumentName;
            return this;
        }

        public LinkBuilder sourceNamespace(SchemaNamespace sourceNamespace) {
            this.sourceNamespace = sourceNamespace;
            return this;
        }

        public LinkBuilder targetNamespace(SchemaNamespace targetNamespace) {
            this.targetNamespace = targetNamespace;
            return this;
        }

        public LinkBuilder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        public LinkBuilder topLevelQueryField(String topLevelQueryField) {
            this.topLevelQueryField = topLevelQueryField;
            return this;
        }

        public LinkBuilder sourceInputFieldName(String sourceInputFieldName) {
            this.sourceInputFieldName = sourceInputFieldName;
            return this;
        }

        public LinkBuilder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public LinkBuilder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public LinkBuilder newFieldName(String newFieldName) {
            this.newFieldName = newFieldName;
            return this;
        }

        public LinkBuilder targetFieldMatchingQueryArgument(String targetFieldMatchingQueryArgument) {
            this.targetFieldMatchingQueryArgument = targetFieldMatchingQueryArgument;
            return this;
        }

        public LinkBuilder noSchemaChangeNeeded(boolean noSchemeChangeNeeded) {
            this.noSchemeChangeNeeded = noSchemeChangeNeeded;
            return this;
        }

        public LinkBuilder customTransformation(CustomTransformation customTransformation) {
            this.customTransformation = customTransformation;
            return this;
        }

        public Link build() {
            Objects.requireNonNull(this.sourceNamespace);
            Objects.requireNonNull(this.sourceType);
            Objects.requireNonNull(this.targetNamespace);
            Objects.requireNonNull(this.targetType);
            Objects.requireNonNull(this.newFieldName);
            String topLevelQueryField = Optional.ofNullable(this.topLevelQueryField).orElse(this.newFieldName);
            String sourceInputFieldName = Optional.ofNullable(this.sourceInputFieldName).orElse(this.newFieldName);
            String queryArgumentName = Optional.ofNullable(this.queryArgumentName).orElse("id");
            String targetFieldMatchingQueryArgument = Optional.ofNullable(this.targetFieldMatchingQueryArgument).orElse(queryArgumentName);
            return new Link(this.sourceNamespace, this.sourceType, this.targetNamespace, this.targetType, this.newFieldName, topLevelQueryField, queryArgumentName, sourceInputFieldName, targetFieldMatchingQueryArgument, this.removeInputField, this.nullable, this.noSchemeChangeNeeded, this.customTransformation);
        }
    }

    public static interface CustomTransformation {
        public void createQuery(Field var1, Object var2);

        public DataFetcherResult<Object> unapplyForResult(Field var1, DataFetcherResult<Object> var2);
    }
}

