/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.language;

import graphql.language.Field;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.PropertyDataFetcher;
import java.util.Map;
import java.util.Objects;

public class AliasablePropertyDataFetcher
implements DataFetcher {
    private final String propertyName;
    private final PropertyDataFetcher defaultDataFetcher;

    public AliasablePropertyDataFetcher(String propertyName) {
        this.propertyName = Objects.requireNonNull(propertyName);
        this.defaultDataFetcher = PropertyDataFetcher.fetching((String)propertyName);
    }

    public Object get(DataFetchingEnvironment env) {
        Object source = env.getSource();
        if (source instanceof Map) {
            return this.getValueFromMap((Map)source, env);
        }
        return this.defaultDataFetcher.get(env);
    }

    private Object getValueFromMap(Map source, DataFetchingEnvironment env) {
        String alias;
        Field field = env.getField();
        if (field != null && (alias = field.getAlias()) != null && !alias.isEmpty() && source.containsKey(alias)) {
            return source.get(alias);
        }
        return source.get(this.propertyName);
    }
}

