/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.BraidGraphQL;
import com.atlassian.braid.BraidSchema;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.java.util.BraidLists;
import com.atlassian.braid.transformation.SchemaTransformation;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentation;
import graphql.execution.preparsed.NoOpPreparsedDocumentProvider;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;

public final class Braid {
    private final BraidSchema braidSchema;
    private final BraidRuntime braidRuntime;
    private final Function<BraidSchema, DataLoaderRegistry> dataLoaderRegistryFactory;
    private final BiFunction<BraidSchema, BraidRuntime, GraphQL> factory;

    private Braid(BraidSchema braidSchema, BraidRuntime braidRuntime, Function<BraidSchema, DataLoaderRegistry> dataLoaderRegistryFactory, BiFunction<BraidSchema, BraidRuntime, GraphQL> factory) {
        this.braidSchema = Objects.requireNonNull(braidSchema);
        this.braidRuntime = Objects.requireNonNull(braidRuntime);
        this.dataLoaderRegistryFactory = Objects.requireNonNull(dataLoaderRegistryFactory);
        this.factory = Objects.requireNonNull(factory);
    }

    public static BraidBuilder builder() {
        return new BraidBuilder();
    }

    public GraphQLSchema getSchema() {
        return this.braidSchema.getSchema();
    }

    @Nonnull
    public BraidGraphQL newGraphQL() {
        return new BraidGraphQL(() -> this.dataLoaderRegistryFactory.apply(this.braidSchema), () -> this.factory.apply(this.braidSchema, this.braidRuntime));
    }

    private static GraphQL newGraphQL(BraidRuntime runtime, GraphQLSchema schema, Instrumentation dataLoaderInstrumentation) {
        Objects.requireNonNull(schema);
        GraphQL.Builder graphQlBuilder = new GraphQL.Builder(schema).executionIdProvider(runtime.executionIdProvider).queryExecutionStrategy(runtime.queryExecutionStrategy).preparsedDocumentProvider(runtime.preparsedDocumentProvider).instrumentation((Instrumentation)Braid.chainInstrumentationAndAddDataLoaderDispatcher(runtime.instrumentations, dataLoaderInstrumentation));
        runtime.getMutationExecutionStrategy().ifPresent(arg_0 -> ((GraphQL.Builder)graphQlBuilder).mutationExecutionStrategy(arg_0));
        runtime.getSubscriptionExecutionStrategy().ifPresent(arg_0 -> ((GraphQL.Builder)graphQlBuilder).subscriptionExecutionStrategy(arg_0));
        return graphQlBuilder.build();
    }

    private static ChainedInstrumentation chainInstrumentationAndAddDataLoaderDispatcher(List<Instrumentation> instrumentationList, Instrumentation dataLoaderInstrumentation) {
        return new ChainedInstrumentation(BraidLists.concat(instrumentationList, dataLoaderInstrumentation));
    }

    private static Function<BraidSchema, DataLoaderRegistry> dataLoaderRegistryFactory() {
        return schema -> {
            DataLoaderRegistry registry = new DataLoaderRegistry();
            schema.getBatchLoaders().forEach((key, loader) -> registry.register(key, Braid.newDataLoader(loader)));
            return registry;
        };
    }

    private static DataLoader newDataLoader(BatchLoader loader) {
        return new DataLoader(loader);
    }

    private static final class BraidRuntime {
        private final ExecutionIdProvider executionIdProvider;
        private final ExecutionStrategy queryExecutionStrategy;
        private final ExecutionStrategy mutationExecutionStrategy;
        private final ExecutionStrategy subscriptionExecutionStrategy;
        private final PreparsedDocumentProvider preparsedDocumentProvider;
        private List<Instrumentation> instrumentations = new LinkedList<Instrumentation>();

        private BraidRuntime(ExecutionIdProvider executionIdProvider, ExecutionStrategy queryExecutionStrategy, ExecutionStrategy mutationExecutionStrategy, ExecutionStrategy subscriptionExecutionStrategy, PreparsedDocumentProvider preparsedDocumentProvider, List<Instrumentation> instrumentations) {
            this.executionIdProvider = Objects.requireNonNull(executionIdProvider);
            this.queryExecutionStrategy = Objects.requireNonNull(queryExecutionStrategy);
            this.mutationExecutionStrategy = mutationExecutionStrategy;
            this.subscriptionExecutionStrategy = subscriptionExecutionStrategy;
            this.preparsedDocumentProvider = Objects.requireNonNull(preparsedDocumentProvider);
            this.instrumentations = Objects.requireNonNull(instrumentations);
        }

        public Optional<ExecutionStrategy> getMutationExecutionStrategy() {
            return Optional.ofNullable(this.mutationExecutionStrategy);
        }

        public Optional<ExecutionStrategy> getSubscriptionExecutionStrategy() {
            return Optional.ofNullable(this.subscriptionExecutionStrategy);
        }
    }

    public static final class BraidBuilder {
        private TypeDefinitionRegistry typeDefinitionRegistry = new TypeDefinitionRegistry();
        private List<SchemaSource> schemaSources = new LinkedList<SchemaSource>();
        private BatchLoaderEnvironment batchLoaderEnvironment = null;
        private Consumer<RuntimeWiring.Builder> runtimeWiring = __ -> {};
        private ExecutionIdProvider executionIdProvider = (__, ___, ____) -> ExecutionId.generate();
        private ExecutionStrategy executionStrategy = null;
        private ExecutionStrategy queryExecutionStrategy = null;
        private ExecutionStrategy mutationExecutionStrategy = null;
        private ExecutionStrategy subscriptionExecutionStrategy = null;
        private List<Instrumentation> instrumentations = new LinkedList<Instrumentation>();
        private PreparsedDocumentProvider preparsedDocumentProvider = new NoOpPreparsedDocumentProvider();
        private Supplier<Instrumentation> dataLoaderInstrumentationFactory = DataLoaderDispatcherInstrumentation::new;
        private List<SchemaTransformation> customSchemaTransformations = new ArrayList<SchemaTransformation>();
        private Function<GraphQLSchema, GraphQLSchema> gqlSchemaTransformer = Function.identity();

        public BraidBuilder customSchemaTransformations(List<SchemaTransformation> customSchemaTransformations) {
            this.customSchemaTransformations = customSchemaTransformations;
            return this;
        }

        public BraidBuilder schemaSource(SchemaSource schemaSource) {
            this.schemaSources.add(Objects.requireNonNull(schemaSource));
            return this;
        }

        public BraidBuilder schemaSources(Collection<SchemaSource> schemaSources) {
            this.schemaSources.addAll(Objects.requireNonNull(schemaSources));
            return this;
        }

        public BraidBuilder typeDefinitionRegistry(TypeDefinitionRegistry typeDefinitionRegistry) {
            this.typeDefinitionRegistry = Objects.requireNonNull(typeDefinitionRegistry);
            return this;
        }

        public BraidBuilder withRuntimeWiring(Consumer<RuntimeWiring.Builder> runtimeWiring) {
            this.runtimeWiring = Objects.requireNonNull(runtimeWiring);
            return this;
        }

        public BraidBuilder instrumentation(Instrumentation instrumentation) {
            this.instrumentations.add(Objects.requireNonNull(instrumentation));
            return this;
        }

        public BraidBuilder executionIdProvider(ExecutionIdProvider executionIdProvider) {
            this.executionIdProvider = Objects.requireNonNull(executionIdProvider);
            return this;
        }

        public BraidBuilder executionStrategy(ExecutionStrategy executionStrategy) {
            this.executionStrategy = Objects.requireNonNull(executionStrategy);
            return this;
        }

        public BraidBuilder queryExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.queryExecutionStrategy = Objects.requireNonNull(executionStrategy);
            return this;
        }

        public BraidBuilder mutationExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.mutationExecutionStrategy = Objects.requireNonNull(executionStrategy);
            return this;
        }

        public BraidBuilder subscriptionExecutionStrategy(ExecutionStrategy executionStrategy) {
            this.subscriptionExecutionStrategy = Objects.requireNonNull(executionStrategy);
            return this;
        }

        public BraidBuilder preparsedDocumentProvider(PreparsedDocumentProvider preparsedDocumentProvider) {
            this.preparsedDocumentProvider = Objects.requireNonNull(preparsedDocumentProvider);
            return this;
        }

        public BraidBuilder dataLoaderInstrumentationFactory(Supplier<Instrumentation> factory) {
            this.dataLoaderInstrumentationFactory = Objects.requireNonNull(factory);
            return this;
        }

        public BraidBuilder batchLoaderEnvironment(BatchLoaderEnvironment batchLoaderEnvironment) {
            this.batchLoaderEnvironment = batchLoaderEnvironment;
            return this;
        }

        public BraidBuilder perExecutionSchemaTransform(Function<GraphQLSchema, GraphQLSchema> gqlSchemaTransformer) {
            this.gqlSchemaTransformer = Objects.requireNonNull(gqlSchemaTransformer);
            return this;
        }

        public Braid build() {
            BraidSchema braidSchema = this.newBraidSchema();
            BraidRuntime braidRuntime = this.newBraidRuntime();
            BiFunction<BraidSchema, BraidRuntime, GraphQL> factory = (braidSchemaObj, runtime) -> {
                GraphQLSchema inputGraphQLSchema = braidSchemaObj.getSchema();
                GraphQLSchema graphQLSchema = Objects.requireNonNull(this.gqlSchemaTransformer.apply(inputGraphQLSchema));
                return Braid.newGraphQL(runtime, graphQLSchema, this.dataLoaderInstrumentationFactory.get());
            };
            return new Braid(braidSchema, braidRuntime, Braid.dataLoaderRegistryFactory(), factory);
        }

        private BraidRuntime newBraidRuntime() {
            return new BraidRuntime(this.executionIdProvider, this.getQueryExecutionStrategy(), Optional.ofNullable(this.mutationExecutionStrategy).orElse(this.executionStrategy), Optional.ofNullable(this.subscriptionExecutionStrategy).orElse(this.executionStrategy), this.preparsedDocumentProvider, this.instrumentations);
        }

        private ExecutionStrategy getQueryExecutionStrategy() {
            return Optional.ofNullable(Optional.ofNullable(this.queryExecutionStrategy).orElse(this.executionStrategy)).orElse((ExecutionStrategy)new AsyncExecutionStrategy());
        }

        private BraidSchema newBraidSchema() {
            return BraidSchema.from(this.typeDefinitionRegistry, this.getRuntimeWiringBuilder(), this.schemaSources, this.customSchemaTransformations, this.batchLoaderEnvironment);
        }

        private RuntimeWiring.Builder getRuntimeWiringBuilder() {
            RuntimeWiring.Builder runtimeWiringBuilder = RuntimeWiring.newRuntimeWiring();
            this.runtimeWiring.accept(runtimeWiringBuilder);
            return runtimeWiringBuilder;
        }
    }
}

