/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.MapperInputOutput;
import com.atlassian.braid.mapper.MapperInputOutputPair;
import com.atlassian.braid.mapper.MapperOperation;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

final class PutOperation<V>
implements MapperOperation {
    private final String key;
    private final Supplier<V> value;
    private final Predicate<MapperInputOutput> predicate;

    PutOperation(String key, Supplier<V> value, Predicate<MapperInputOutput> predicate) {
        this.key = Objects.requireNonNull(key);
        this.value = Objects.requireNonNull(value);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        if (this.predicate.test(MapperInputOutputPair.of(input, output))) {
            output.put(this.key, this.value.get());
        }
    }
}

