/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mutation;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.mutation.BraidSchemaSource;
import com.atlassian.braid.mutation.BraidingContext;
import com.atlassian.braid.mutation.DataFetcherUtils;
import com.atlassian.braid.mutation.FieldMutationInjector;
import com.atlassian.braid.mutation.LinkMutation;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.dataloader.BatchLoader;

public class LinkMutationInjector
implements FieldMutationInjector {
    @Override
    public Map<String, BatchLoader> inject(BraidingContext braidingContext) {
        return LinkMutationInjector.linkTypes(braidingContext.getDataSources(), braidingContext.getQueryObjectTypeDefinition(), braidingContext.getMutationObjectTypeDefinition(), braidingContext.getRuntimeWiringBuilder());
    }

    private static Map<String, BatchLoader> linkTypes(Map<SchemaNamespace, BraidSchemaSource> sources, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, RuntimeWiring.Builder runtimeWiringBuilder) {
        HashMap<String, BatchLoader> batchLoaders = new HashMap<String, BatchLoader>();
        for (BraidSchemaSource source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = source.getTypeRegistry();
            TypeDefinitionRegistry privateTypes = source.getSchemaSource().getPrivateSchema();
            HashMap<String, TypeDefinition> dsTypes = new HashMap<String, TypeDefinition>(typeRegistry.types());
            for (Link link : source.getSchemaSource().getLinks()) {
                BraidSchemaSource targetSource;
                ObjectTypeDefinition typeDefinition = LinkMutationInjector.getObjectTypeDefinition(queryObjectTypeDefinition, mutationObjectTypeDefinition, typeRegistry, dsTypes, source.getLinkBraidSourceType(link));
                LinkMutationInjector.validateSourceFromFieldExists(link, privateTypes);
                Optional<FieldDefinition> sourceField = typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceField())).findFirst();
                Optional<FieldDefinition> sourceFromField = typeDefinition.getFieldDefinitions().stream().filter(Objects::nonNull).filter(s -> s.getName().equals(link.getSourceFromField())).findAny();
                if (sourceFromField.isPresent() && link.isReplaceFromField()) {
                    typeDefinition.getFieldDefinitions().remove(sourceFromField.get());
                }
                if ((targetSource = sources.get(link.getTargetNamespace())) == null) {
                    throw new IllegalArgumentException("Can't find target schema source: " + link.getTargetNamespace());
                }
                if (!targetSource.hasType(link.getTargetType())) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                TypeName targetType = new TypeName(link.getTargetType());
                if (!sourceField.isPresent()) {
                    if (sourceFromField.isPresent() && LinkMutationInjector.isListType(sourceFromField.get().getType())) {
                        targetType = new ListType((Type)targetType);
                    }
                    FieldDefinition field = new FieldDefinition(link.getSourceField(), (Type)targetType);
                    typeDefinition.getFieldDefinitions().add(field);
                } else if (LinkMutationInjector.isListType(sourceField.get().getType())) {
                    if (sourceField.get().getType() instanceof NonNullType) {
                        sourceField.get().setType((Type)new NonNullType((Type)new ListType((Type)targetType)));
                    } else {
                        sourceField.get().setType((Type)new ListType((Type)targetType));
                    }
                } else {
                    sourceField.get().setType((Type)targetType);
                }
                String type = source.getLinkBraidSourceType(link);
                String field = link.getSourceField();
                String linkDataLoaderKey = DataFetcherUtils.getLinkDataLoaderKey(type, field);
                runtimeWiringBuilder.type(type, wiring -> wiring.dataFetcher(field, env -> ((BraidContext)env.getContext()).getDataLoaderRegistry().getDataLoader(linkDataLoaderKey).load((Object)env)));
                batchLoaders.put(linkDataLoaderKey, targetSource.getSchemaSource().newBatchLoader(targetSource.getSchemaSource(), new LinkMutation(link)));
            }
        }
        return batchLoaders;
    }

    private static ObjectTypeDefinition getObjectTypeDefinition(ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, TypeDefinitionRegistry typeRegistry, Map<String, TypeDefinition> dsTypes, String linkSourceType) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(linkSourceType);
        if (typeDefinition == null && linkSourceType.equals(queryObjectTypeDefinition.getName()) && (typeDefinition = (ObjectTypeDefinition)TypeUtils.findQueryType(typeRegistry).orElse(null)) == null && linkSourceType.equals(mutationObjectTypeDefinition.getName())) {
            typeDefinition = TypeUtils.findMutationType(typeRegistry).orElse(null);
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Can't find source type: " + linkSourceType);
        }
        return typeDefinition;
    }

    private static void validateSourceFromFieldExists(Link link, TypeDefinitionRegistry privateTypeDefinitionRegistry) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)privateTypeDefinitionRegistry.getType(link.getSourceType(), ObjectTypeDefinition.class).orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source type '%s' in private schema for link %s", link.getSourceType(), link.getSourceField())));
        typeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getSourceFromField())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source from field: %s", link.getSourceFromField())));
    }

    private static boolean isListType(Type type) {
        return type instanceof ListType || type instanceof NonNullType && ((NonNullType)type).getType() instanceof ListType;
    }
}

