/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mutation;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldMutation;
import com.atlassian.braid.FieldMutationContext;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.mutation.FieldWithCounter;
import com.atlassian.braid.mutation.QueryMutationUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.InputValueDefinition;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ExtensionMutation
implements FieldMutation {
    private final Extension extension;

    ExtensionMutation(Extension extension) {
        this.extension = Objects.requireNonNull(extension);
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldMutationContext context) {
        Map source;
        if (environment.getSource() instanceof DataFetcherResult) {
            source = (Map)((DataFetcherResult)environment.getSource()).getData();
        } else if (environment.getSource() instanceof Map) {
            source = (Map)environment.getSource();
        } else {
            throw new IllegalArgumentException("Unexpected source type: " + environment.getSource());
        }
        Object targetId = source.get(this.extension.getOn());
        OperationDefinition operationDefinition = QueryMutationUtils.getOperationDefinition(environment);
        FieldWithCounter field = QueryMutationUtils.cloneField(context, new ArrayList<Integer>(), environment);
        this.addQueryVariable(context, targetId, field);
        QueryMutationUtils.addFieldToQuery(context, environment, operationDefinition, field);
        SelectionSet selectionSet = SelectionSet.newSelectionSet().selections(((BraidContext)environment.getContext()).getMissingFields(environment.getFieldType().getName())).build();
        field.field.setSelectionSet(selectionSet);
        return CompletableFuture.completedFuture(Collections.singletonList(field.field));
    }

    private void addQueryVariable(FieldMutationContext fieldMutationContext, Object targetId, FieldWithCounter field) {
        String variableName = this.extension.getBy().getArg() + fieldMutationContext.getCounter();
        field.field.setName(this.extension.getBy().getQuery());
        field.field.setArguments(ExtensionMutation.linkQueryArgumentAsList(this.extension, variableName));
        fieldMutationContext.getQueryOp().getVariableDefinitions().add(ExtensionMutation.linkQueryVariableDefinition(this.extension, variableName, fieldMutationContext.getSchemaSource()));
        fieldMutationContext.getVariables().put(variableName, targetId);
    }

    private static List<Argument> linkQueryArgumentAsList(Extension link, String variableName) {
        return Collections.singletonList(new Argument(link.getBy().getArg(), (Value)new VariableReference(variableName)));
    }

    private static VariableDefinition linkQueryVariableDefinition(Extension link, String variableName, SchemaSource schemaSource) {
        return new VariableDefinition(variableName, ExtensionMutation.findArgumentType(schemaSource, link));
    }

    private static Type findArgumentType(SchemaSource schemaSource, Extension link) {
        return TypeUtils.findQueryFieldDefinitions(schemaSource.getPrivateSchema()).orElseThrow(IllegalStateException::new).stream().filter(f -> f.getName().equals(link.getBy().getQuery())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getBy().getArg())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }
}

