/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mutation;

import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeAlias;
import com.atlassian.braid.mutation.BraidSchemaSource;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BraidTypeDefinition {
    private static final Logger log = LoggerFactory.getLogger(BraidTypeDefinition.class);
    private final BraidSchemaSource source;
    private final TypeDefinition typeDefinition;

    BraidTypeDefinition(BraidSchemaSource source, TypeDefinition typeDefinition) {
        this.source = source;
        this.typeDefinition = typeDefinition;
    }

    public String getName() {
        return this.source.getTypeAlias(this.typeDefinition.getName()).map(TypeAlias::getBraidName).orElse(this.typeDefinition.getName());
    }

    public SchemaNamespace getNamespace() {
        return this.source.getNamespace();
    }

    public List<FieldDefinition> getFieldDefinitions() {
        return BraidTypeDefinition.getFieldDefinitions(this.typeDefinition);
    }

    public static List<FieldDefinition> getFieldDefinitions(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof ObjectTypeDefinition) {
            return ((ObjectTypeDefinition)typeDefinition).getFieldDefinitions();
        }
        if (typeDefinition instanceof InterfaceTypeDefinition) {
            return ((InterfaceTypeDefinition)typeDefinition).getFieldDefinitions();
        }
        return Collections.emptyList();
    }

    public TypeDefinition getType() {
        return this.source.getTypeAlias(this.typeDefinition.getName()).map(this::newTypeDefinition).orElse(this.typeDefinition);
    }

    private TypeDefinition newTypeDefinition(TypeAlias a) {
        if (this.typeDefinition instanceof ObjectTypeDefinition) {
            ObjectTypeDefinition def = (ObjectTypeDefinition)this.typeDefinition;
            return ObjectTypeDefinition.newObjectTypeDefinition().name(a.getBraidName()).implementz(this.aliasImplements(def)).directives(def.getDirectives()).fieldDefinitions(this.aliasFields(def.getFieldDefinitions())).build();
        }
        if (this.typeDefinition instanceof ScalarTypeDefinition) {
            ScalarTypeDefinition def = (ScalarTypeDefinition)this.typeDefinition;
            return ScalarTypeDefinition.newScalarTypeDefinition().name(a.getBraidName()).directives(def.getDirectives()).build();
        }
        if (this.typeDefinition instanceof EnumTypeDefinition) {
            EnumTypeDefinition def = (EnumTypeDefinition)this.typeDefinition;
            return EnumTypeDefinition.newEnumTypeDefinition().name(a.getBraidName()).enumValueDefinitions(def.getEnumValueDefinitions()).directives(def.getDirectives()).build();
        }
        if (this.typeDefinition instanceof InterfaceTypeDefinition) {
            InterfaceTypeDefinition def = (InterfaceTypeDefinition)this.typeDefinition;
            return InterfaceTypeDefinition.newInterfaceTypeDefinition().name(a.getBraidName()).definitions(this.aliasFields(def.getFieldDefinitions())).directives(def.getDirectives()).build();
        }
        if (this.typeDefinition instanceof InputObjectTypeDefinition) {
            InputObjectTypeDefinition def = (InputObjectTypeDefinition)this.typeDefinition;
            return InputObjectTypeDefinition.newInputObjectDefinition().name(a.getBraidName()).directives(def.getDirectives()).inputValueDefinitions(this.source.aliasInputValueDefinitions(def.getInputValueDefinitions())).build();
        }
        log.warn("Unhandled type definition for aliasing: {}  Please report as a bug.", (Object)this.typeDefinition);
        return this.typeDefinition;
    }

    private List<FieldDefinition> aliasFields(List<FieldDefinition> fieldDefinitions) {
        return fieldDefinitions.stream().map(field -> FieldDefinition.newFieldDefinition().name(field.getName()).type(this.source.aliasType(field.getType())).inputValueDefinitions(this.source.aliasInputValueDefinitions(field.getInputValueDefinitions())).directives(field.getDirectives()).build()).collect(Collectors.toList());
    }

    private List<Type> aliasImplements(ObjectTypeDefinition def) {
        return def.getImplements().stream().map(this.source::aliasType).collect(Collectors.toList());
    }
}

