/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mutation;

import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeAlias;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.mutation.BraidTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraidSchemaSource {
    private static final Logger log = LoggerFactory.getLogger(BraidSchemaSource.class);
    private final SchemaSource schemaSource;
    private final TypeDefinitionRegistry registry;
    private final ObjectTypeDefinition queryType;
    private final ObjectTypeDefinition mutationType;

    public BraidSchemaSource(SchemaSource schemaSource) {
        this.schemaSource = Objects.requireNonNull(schemaSource);
        this.registry = schemaSource.getSchema();
        this.queryType = TypeUtils.findQueryType(this.registry).orElse(null);
        this.mutationType = TypeUtils.findMutationType(this.registry).orElse(null);
    }

    public SchemaSource getSchemaSource() {
        return this.schemaSource;
    }

    public SchemaNamespace getNamespace() {
        return this.schemaSource.getNamespace();
    }

    List<Extension> getExtensions(String type) {
        return this.schemaSource.getExtensions().stream().filter(e -> e.getType().equals(type)).collect(Collectors.toList());
    }

    Optional<TypeAlias> getTypeAlias(String type) {
        return this.schemaSource.getTypeAliases().stream().filter(a -> a.getSourceName().equals(type)).findFirst();
    }

    public Optional<TypeAlias> getTypeAliasFromAlias(String type) {
        return this.schemaSource.getTypeAliases().stream().filter(a -> a.getBraidName().equals(type)).findFirst();
    }

    public String getBraidTypeName(String sourceTypeName) {
        return this.getTypeAlias(sourceTypeName).map(TypeAlias::getBraidName).orElse(sourceTypeName);
    }

    public String getSourceTypeName(String braidTypeName) {
        return this.getTypeAliasFromAlias(braidTypeName).map(TypeAlias::getSourceName).orElse(braidTypeName);
    }

    Optional<FieldAlias> getQueryFieldAlias(String sourceFieldName) {
        return this.getFieldAlias(this.schemaSource.getQueryFieldAliases(), sourceFieldName);
    }

    Optional<FieldAlias> getMutationFieldAliases(String sourceFieldName) {
        return this.getFieldAlias(this.schemaSource.getMutationFieldAliases(), sourceFieldName);
    }

    public String getLinkBraidSourceType(Link link) {
        return this.getQueryType().map(originalQueryType -> {
            if (originalQueryType.getName().equals(link.getSourceType())) {
                return "Query";
            }
            return link.getSourceType();
        }).orElse(link.getSourceType());
    }

    public Collection<BraidTypeDefinition> getNonOperationTypes() {
        return this.registry.types().values().stream().filter(this::isNotOperationType).map(td -> new BraidTypeDefinition(this, (TypeDefinition)td)).collect(Collectors.toList());
    }

    boolean hasType(String type) {
        return this.getType(type).isPresent();
    }

    Optional<TypeDefinition> getType(String type) {
        return this.registry.getType(type);
    }

    Optional<ObjectTypeDefinition> getQueryType() {
        return Optional.ofNullable(this.queryType);
    }

    Optional<ObjectTypeDefinition> getMutationType() {
        return Optional.ofNullable(this.mutationType);
    }

    TypeDefinitionRegistry getTypeRegistry() {
        return this.registry;
    }

    Type aliasType(Type type) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            TypeAlias alias = this.getTypeAlias(typeName).orElse(TypeAlias.from(typeName, typeName));
            return new TypeName(alias.getBraidName());
        }
        if (type instanceof NonNullType) {
            return new NonNullType(this.aliasType(((NonNullType)type).getType()));
        }
        if (type instanceof ListType) {
            return new ListType(this.aliasType(((ListType)type).getType()));
        }
        log.error("Definition type : " + type + " not handled correctly for aliases.  Please raise an issue.");
        return type;
    }

    public Type unaliasType(Type type) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            TypeAlias alias = this.getTypeAliasFromAlias(typeName).orElse(TypeAlias.from(typeName, typeName));
            return new TypeName(alias.getSourceName());
        }
        if (type instanceof NonNullType) {
            return new NonNullType(this.unaliasType(((NonNullType)type).getType()));
        }
        if (type instanceof ListType) {
            return new ListType(this.unaliasType(((ListType)type).getType()));
        }
        log.error("Definition type : " + type + " not handled correctly for aliases.  Please raise an issue.");
        return type;
    }

    List<InputValueDefinition> aliasInputValueDefinitions(List<InputValueDefinition> inputValueDefinitions) {
        return inputValueDefinitions.stream().map(input -> InputValueDefinition.newInputValueDefinition().name(input.getName()).type(this.aliasType(input.getType())).defaultValue(input.getDefaultValue()).directives(input.getDirectives()).build()).collect(Collectors.toList());
    }

    private Optional<FieldAlias> getFieldAlias(List<FieldAlias> aliases, String sourceName) {
        if (aliases.isEmpty()) {
            return Optional.of(FieldAlias.from(sourceName, sourceName));
        }
        return aliases.stream().filter(a -> a.getSourceName().equals(sourceName)).findFirst();
    }

    private Optional<FieldAlias> getFieldAliasFromAlias(List<FieldAlias> aliases, String braidFieldName) {
        if (aliases.isEmpty()) {
            return Optional.of(FieldAlias.from(braidFieldName, braidFieldName));
        }
        return aliases.stream().filter(a -> a.getBraidName().equals(braidFieldName)).findFirst();
    }

    private boolean isNotOperationType(TypeDefinition typeDefinition) {
        return !this.isOperationType(typeDefinition);
    }

    private boolean isOperationType(TypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        return Objects.equals(this.queryType, typeDefinition) || Objects.equals(this.mutationType, typeDefinition);
    }

    boolean hasTypeAndField(TypeDefinitionRegistry registry, TypeDefinition typeDef, FieldDefinition fieldDef) {
        if (TypeUtils.findQueryType(registry).map(qType -> qType == typeDef).orElse(false).booleanValue()) {
            return this.getFieldAliasFromAlias(this.schemaSource.getQueryFieldAliases(), fieldDef.getName()).map(alias -> alias.getBraidName().equals(fieldDef.getName())).orElse(false);
        }
        return this.getType(this.getSourceTypeName(typeDef.getName())).isPresent();
    }
}

