/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.java.util.BraidPreconditions;
import graphql.execution.ExecutionContext;
import graphql.language.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dataloader.DataLoaderRegistry;

final class MutableBraidContext<C>
implements BraidContext<C> {
    private final AtomicReference<ExecutionContext> executionContext;
    private final DataLoaderRegistry dataLoaderRegistry;
    private final Map<String, List<Field>> missingFieldsByType = new HashMap<String, List<Field>>();
    @Nullable
    private final C context;

    MutableBraidContext(@Nonnull DataLoaderRegistry dataLoaderRegistry, @Nullable C context) {
        this.executionContext = new AtomicReference();
        this.dataLoaderRegistry = Objects.requireNonNull(dataLoaderRegistry);
        this.context = context;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        ExecutionContext context = this.executionContext.get();
        BraidPreconditions.checkState(context != null, "Method called too early, before the execution context had a chance to be set", new Object[0]);
        return context;
    }

    ExecutionContext setExecutionContext(ExecutionContext newExecutionContext) {
        this.executionContext.set(newExecutionContext);
        return newExecutionContext;
    }

    @Override
    public void addMissingFields(String typeName, List<Field> fields) {
        this.missingFieldsByType.put(typeName, fields);
    }

    @Override
    public List<Field> getMissingFields(String typeName) {
        return this.missingFieldsByType.get(typeName);
    }

    @Override
    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry;
    }

    @Override
    public C getContext() {
        return this.context;
    }
}

