/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeAlias;
import com.atlassian.braid.document.DocumentMapperFactory;
import com.atlassian.braid.document.DocumentMappers;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.BaseQueryExecutorSchemaSource;
import com.atlassian.braid.source.ForwardingSchemaSource;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.MapGraphQLError;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.SchemaUtils;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GraphQLRemoteSchemaSource<C>
extends ForwardingSchemaSource
implements QueryExecutorSchemaSource {
    private final BaseQueryExecutorSchemaSource<C> delegate;
    private final GraphQLRemoteRetriever<C> graphQLRemoteRetriever;

    private GraphQLRemoteSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry publicSchema, TypeDefinitionRegistry privateSchema, GraphQLRemoteRetriever<C> graphQLRemoteRetriever, List<Link> links, DocumentMapperFactory documentMapperFactory, List<TypeAlias> typeAliases, List<FieldAlias> queryFieldAliases, List<FieldAlias> mutationFieldAliases) {
        this.graphQLRemoteRetriever = Objects.requireNonNull(graphQLRemoteRetriever);
        this.delegate = new BaseQueryExecutorSchemaSource<Object>(namespace, publicSchema, privateSchema, links, documentMapperFactory, this::query, typeAliases, queryFieldAliases, mutationFieldAliases);
    }

    public static <C> Builder<C> builder() {
        return new Builder();
    }

    @Override
    protected SchemaSource getDelegate() {
        return this.delegate;
    }

    public CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput query, C context) {
        return this.graphQLRemoteRetriever.queryGraphQL(query, context).thenApply(response -> {
            Map data = Optional.ofNullable(response.get("data")).map(BraidObjects::cast).orElse(Collections.emptyMap());
            List errorsMap = Optional.ofNullable(response.get("errors")).map(BraidObjects::cast).orElse(Collections.emptyList());
            List errors = errorsMap.stream().map(val -> Optional.ofNullable(val).map(BraidObjects::cast).orElseThrow(IllegalArgumentException::new)).map(MapGraphQLError::new).collect(Collectors.toList());
            return new DataFetcherResult(data, errors);
        });
    }

    public static class Builder<C> {
        private List<Link> links = Collections.emptyList();
        private Supplier<Reader> schemaProvider;
        private SchemaNamespace schemaNamespace;
        private DocumentMapperFactory documentMapperFactory = DocumentMappers.identity();
        private GraphQLRemoteRetriever<C> remoteRetriever;
        private List<FieldAlias> queryFieldAliases = Collections.emptyList();
        private List<FieldAlias> mutationFieldAliases = Collections.emptyList();
        private List<TypeAlias> typeAliases = Collections.emptyList();

        private Builder() {
        }

        public Builder<C> schemaProvider(Supplier<Reader> schemaProvider) {
            this.schemaProvider = schemaProvider;
            return this;
        }

        public Builder<C> queryFieldAliases(List<FieldAlias> fieldAliases) {
            this.queryFieldAliases = fieldAliases;
            return this;
        }

        public Builder<C> mutationFieldAliases(List<FieldAlias> fieldAliases) {
            this.mutationFieldAliases = fieldAliases;
            return this;
        }

        public Builder<C> topLevelFields(String ... topLevelFields) {
            return this.queryFieldAliases(Arrays.stream(topLevelFields).map(name -> FieldAlias.from(name, name)).collect(Collectors.toList()));
        }

        public Builder<C> namespace(SchemaNamespace schemaNamespace) {
            this.schemaNamespace = schemaNamespace;
            return this;
        }

        public Builder<C> links(List<Link> links) {
            this.links = links;
            return this;
        }

        public Builder<C> documentMapperFactory(DocumentMapperFactory documentMapperFactory) {
            this.documentMapperFactory = documentMapperFactory;
            return this;
        }

        public Builder<C> remoteRetriever(GraphQLRemoteRetriever<C> remoteRetriever) {
            this.remoteRetriever = remoteRetriever;
            return this;
        }

        public Builder<C> typeAliases(List<TypeAlias> typeAliases) {
            this.typeAliases = typeAliases;
            return this;
        }

        public GraphQLRemoteSchemaSource<C> build() {
            return new GraphQLRemoteSchemaSource(Objects.requireNonNull(this.schemaNamespace), SchemaUtils.loadPublicSchema(Objects.requireNonNull(this.schemaProvider), Objects.requireNonNull(this.links), (String[])this.queryFieldAliases.stream().map(FieldAlias::getSourceName).toArray(String[]::new)), SchemaUtils.loadSchema(Objects.requireNonNull(this.schemaProvider)), Objects.requireNonNull(this.remoteRetriever), Objects.requireNonNull(this.links), Objects.requireNonNull(this.documentMapperFactory), Objects.requireNonNull(this.typeAliases), Objects.requireNonNull(this.queryFieldAliases), Objects.requireNonNull(this.mutationFieldAliases));
        }
    }
}

