/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BraidSchemaSource;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeAlias;
import graphql.language.EnumTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BraidTypeDefinition {
    private static final Logger log = LoggerFactory.getLogger(BraidTypeDefinition.class);
    private final BraidSchemaSource source;
    private final TypeDefinition typeDefinition;

    public BraidTypeDefinition(BraidSchemaSource source, TypeDefinition typeDefinition) {
        this.source = source;
        this.typeDefinition = typeDefinition;
    }

    public String getName() {
        return this.source.getTypeAlias(this.typeDefinition.getName()).map(TypeAlias::getBraidName).orElse(this.typeDefinition.getName());
    }

    public SchemaNamespace getNamespace() {
        return this.source.getNamespace();
    }

    public List<FieldDefinition> getFieldDefinitions() {
        if (this.typeDefinition instanceof ObjectTypeDefinition) {
            return ((ObjectTypeDefinition)this.typeDefinition).getFieldDefinitions();
        }
        return Collections.emptyList();
    }

    public TypeDefinition getType() {
        return this.source.getTypeAlias(this.typeDefinition.getName()).map(this::newTypeDefinition).orElse(this.typeDefinition);
    }

    private TypeDefinition newTypeDefinition(TypeAlias a) {
        if (this.typeDefinition instanceof ObjectTypeDefinition) {
            ObjectTypeDefinition def = (ObjectTypeDefinition)this.typeDefinition;
            return new ObjectTypeDefinition(a.getBraidName(), this.aliasImplements(def), def.getDirectives(), this.aliasFields(def.getFieldDefinitions()));
        }
        if (this.typeDefinition instanceof ScalarTypeDefinition) {
            ScalarTypeDefinition def = (ScalarTypeDefinition)this.typeDefinition;
            return new ScalarTypeDefinition(a.getBraidName(), def.getDirectives());
        }
        if (this.typeDefinition instanceof EnumTypeDefinition) {
            EnumTypeDefinition def = (EnumTypeDefinition)this.typeDefinition;
            return new EnumTypeDefinition(a.getBraidName(), def.getEnumValueDefinitions(), def.getDirectives());
        }
        if (this.typeDefinition instanceof InterfaceTypeDefinition) {
            InterfaceTypeDefinition def = (InterfaceTypeDefinition)this.typeDefinition;
            return new InterfaceTypeDefinition(a.getBraidName(), this.aliasFields(def.getFieldDefinitions()), def.getDirectives());
        }
        if (this.typeDefinition instanceof InputObjectTypeDefinition) {
            InputObjectTypeDefinition def = (InputObjectTypeDefinition)this.typeDefinition;
            return new InputObjectTypeDefinition(a.getBraidName(), def.getDirectives(), this.source.aliasInputValueDefinitions(def.getInputValueDefinitions()));
        }
        log.warn("Unhandled type definition for aliasing: {}  Please report as a bug.", (Object)this.typeDefinition);
        return this.typeDefinition;
    }

    private List<FieldDefinition> aliasFields(List<FieldDefinition> fieldDefinitions) {
        return fieldDefinitions.stream().map(field -> new FieldDefinition(field.getName(), this.source.aliasType(field.getType()), this.source.aliasInputValueDefinitions(field.getInputValueDefinitions()), field.getDirectives())).collect(Collectors.toList());
    }

    private List<Type> aliasImplements(ObjectTypeDefinition def) {
        return def.getImplements().stream().map(this.source::aliasType).collect(Collectors.toList());
    }
}

