/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.java.util.BraidPreconditions;
import graphql.execution.ExecutionContext;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dataloader.DataLoaderRegistry;

final class MutableBraidContext<C>
implements BraidContext<C> {
    private final AtomicReference<ExecutionContext> executionContext = new AtomicReference();
    private final DataLoaderRegistry dataLoaderRegistry;
    @Nullable
    private final C context;

    MutableBraidContext(@Nonnull DataLoaderRegistry dataLoaderRegistry, @Nullable C context) {
        this.dataLoaderRegistry = Objects.requireNonNull(dataLoaderRegistry);
        this.context = context;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        ExecutionContext context = this.executionContext.get();
        BraidPreconditions.checkState(context != null, "Method called too early, before the execution context had a chance to be set", new Object[0]);
        return context;
    }

    ExecutionContext setExecutionContext(ExecutionContext newExecutionContext) {
        this.executionContext.set(newExecutionContext);
        return newExecutionContext;
    }

    @Override
    public DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistry;
    }

    @Override
    public C getContext() {
        return this.context;
    }
}

