/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.MapperException;
import java.util.Map;
import java.util.Optional;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

final class SpringExpressions {
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    SpringExpressions() {
    }

    <T> Optional<T> get(Map<String, Object> map, String key) {
        String sourcePath = !key.contains("[") ? "['" + key + "']" : key;
        return Optional.ofNullable(SpringExpressions.maybeGetValue(map, sourcePath)).map(BraidObjects::cast);
    }

    private static Object maybeGetValue(Object source, String sourcePath) {
        try {
            return PARSER.parseExpression(sourcePath).getValue(source);
        }
        catch (SpelEvaluationException e) {
            throw new MapperException(e, "Exception getting value in %s for path: %s", source, sourcePath);
        }
    }
}

