/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.document.MappedDefinitions;
import com.atlassian.braid.document.MappingContext;
import com.atlassian.braid.document.QueryDocuments;
import com.atlassian.braid.document.RootDefinitionMappingResult;
import com.atlassian.braid.document.SelectionMapper;
import com.atlassian.braid.document.SelectionSetMappingResult;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.java.util.BraidLists;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.MapperOperations;
import com.atlassian.braid.mapper.Mappers;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

final class TypedDocumentMapper
implements DocumentMapper {
    private final TypeDefinitionRegistry schema;
    private final List<TypeMapper> typeMappers;

    TypedDocumentMapper(TypeDefinitionRegistry schema, List<TypeMapper> typeMappers) {
        this.schema = Objects.requireNonNull(schema);
        this.typeMappers = Objects.requireNonNull(typeMappers);
    }

    @Override
    public DocumentMapper.MappedDocument apply(Document input) {
        return this.apply(MappingContext.rootContext(this.schema, this.typeMappers), input);
    }

    private DocumentMapper.MappedDocument apply(MappingContext.RootMappingContext context, Document input) {
        return this.apply(context, QueryDocuments.groupRootDefinitionsByType(input));
    }

    private DocumentMapper.MappedDocument apply(MappingContext.RootMappingContext context, Map<Class<?>, List<Definition>> rootDefinitions) {
        List<FragmentDefinition> fragmentDefinitions = TypedDocumentMapper.getDefinitionsOfType(rootDefinitions, FragmentDefinition.class);
        List<OperationDefinition> operationDefinitions = TypedDocumentMapper.getDefinitionsOfType(rootDefinitions, OperationDefinition.class);
        MappingContext.RootMappingContext contextWithFragmentDefinitions = context.withFragments(fragmentDefinitions);
        return this.apply(contextWithFragmentDefinitions, operationDefinitions, fragmentDefinitions);
    }

    private DocumentMapper.MappedDocument apply(MappingContext.RootMappingContext context, List<OperationDefinition> operationDefinitions, List<FragmentDefinition> fragmentDefinitions) {
        List<FragmentDefinition> mappedFragmentDefinitions = this.mapFragmentDefinitions(context, fragmentDefinitions);
        MappedDefinitions mappedOperationDefinitions = TypedDocumentMapper.mapOperationDefinitions(context, operationDefinitions);
        return new DocumentMapper.MappedDocument(TypedDocumentMapper.getDocument(BraidLists.concat(mappedOperationDefinitions.getDefinitions(), mappedFragmentDefinitions)), Mappers.mapper(MapperOperations.composed(mappedOperationDefinitions.getMappers())));
    }

    private List<FragmentDefinition> mapFragmentDefinitions(MappingContext.RootMappingContext context, List<FragmentDefinition> fragmentDefinitions) {
        return fragmentDefinitions.stream().map(fd -> TypedDocumentMapper.mapFragment(context.forFragment((FragmentDefinition)fd), fd)).collect(Collectors.toList());
    }

    private static FragmentDefinition mapFragment(MappingContext.FragmentDefinitionMappingContext mappingContext, FragmentDefinition fd) {
        return mappingContext.getTypeMapper().map(tm -> (SelectionSetMappingResult)tm.apply(mappingContext, fd.getSelectionSet())).map(SelectionSetMappingResult::getSelectionSet).map(ss -> new FragmentDefinition(fd.getName(), fd.getTypeCondition(), fd.getDirectives(), ss)).orElse(fd);
    }

    private static MappedDefinitions mapOperationDefinitions(MappingContext.RootMappingContext context, List<OperationDefinition> operationDefinitions) {
        return operationDefinitions.stream().map(od -> TypedDocumentMapper.mapOperation(context.forOperationDefinition((OperationDefinition)od), od)).collect(MappedDefinitions.toMappedDefinitions());
    }

    private static RootDefinitionMappingResult mapOperation(MappingContext.OperationDefinitionMappingContext mappingContext, OperationDefinition operationDefinition) {
        return operationDefinition.getSelectionSet().getSelections().stream().map(SelectionMapper::getSelectionMapper).map(selectionMapper -> selectionMapper.map(mappingContext)).collect(RootDefinitionMappingResult.toOperationMappingResult(operationDefinition));
    }

    private static Document getDocument(List<? extends Definition> rootDefinitions) {
        Document document = new Document();
        document.getDefinitions().addAll(rootDefinitions);
        return document;
    }

    private static <D extends Definition> List<D> getDefinitionsOfType(Map<Class<?>, List<Definition>> rootDefinitions, Class<D> type) {
        return (List)BraidObjects.cast(rootDefinitions.getOrDefault(type, Collections.emptyList()));
    }
}

