/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.botocss;

import com.atlassian.botocss.BotocssStyles;
import com.atlassian.botocss.DocumentFunctions;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermTime;
import cz.vutbr.web.css.TermURI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Botocss {
    private static final Logger log = LoggerFactory.getLogger(Botocss.class);
    private static final Pattern CAN_SHORTEN_COLOR_PATTERN = Pattern.compile("^#([0-9a-f])\\1([0-9a-f])\\2([0-9a-f])\\3$");
    private static final String SHORTEN_COLOR_REPLACEMENT = "#$1$2$3";

    public static String inject(String html, String ... stylesheets) {
        log.debug("Parsing external stylesheets");
        BotocssStyles styles = BotocssStyles.parse(stylesheets);
        return Botocss.inject(html, styles);
    }

    public static String inject(String html, BotocssStyles styles) {
        return Botocss.inject(html, styles, DocumentFunctions.PRETTY_PRINT);
    }

    public static String inject(String html, BotocssStyles styles, Function<Document, Document> documentFunction) {
        Document processedDocumentWithCSSInlined;
        long start = System.currentTimeMillis();
        Document documentWithCSSInlined = Jsoup.parse((String)html);
        log.debug("Parsed HTML document in {} ms", (Object)(System.currentTimeMillis() - start));
        int selectorCount = 0;
        log.debug("Applying external stylesheets");
        selectorCount += Botocss.applyStyles(documentWithCSSInlined, styles);
        log.debug("Finding inline stylesheets");
        ArrayList<String> inlineCss = new ArrayList<String>();
        for (Element inlineStyle : documentWithCSSInlined.getElementsByTag("style")) {
            inlineCss.add(inlineStyle.html());
        }
        if (!inlineCss.isEmpty()) {
            log.debug("Parsing inline stylesheets");
            BotocssStyles inlineStyles = BotocssStyles.parse(inlineCss.toArray(new String[inlineCss.size()]));
            log.debug("Applying inline stylesheets");
            selectorCount += Botocss.applyStyles(documentWithCSSInlined, inlineStyles);
        }
        if ((processedDocumentWithCSSInlined = (Document)documentFunction.apply((Object)documentWithCSSInlined)) == null) {
            processedDocumentWithCSSInlined = documentWithCSSInlined;
        }
        String result = processedDocumentWithCSSInlined.outerHtml();
        log.info("Applying {} CSS selectors to HTML (length {}) took {} ms", new Object[]{selectorCount, html.length(), System.currentTimeMillis() - start});
        return result;
    }

    public static BotocssStyles parse(String ... stylesheets) {
        return BotocssStyles.parse(stylesheets);
    }

    private static int applyStyles(Document document, BotocssStyles styles) {
        int selectorCount = 0;
        for (StyleSheet styleSheet : styles.getStyleSheets()) {
            selectorCount += Botocss.applyStylesheet(document, styleSheet);
        }
        return selectorCount;
    }

    private static int applyStylesheet(Document document, StyleSheet stylesheet) {
        int selectorCount = 0;
        for (RuleBlock block : stylesheet) {
            if (!(block instanceof RuleSet)) continue;
            RuleSet set = (RuleSet)block;
            for (CombinedSelector selector : set.getSelectors()) {
                log.debug("Applying selector #{}: {}", (Object)(++selectorCount), (Object)selector.toString());
                List<Element> elements = Botocss.findElements(document, selector);
                for (Element element : elements) {
                    for (Declaration declaration : set) {
                        log.debug("Applying style [ {} ] to element: {}", (Object)declaration.toString().trim(), (Object)element.nodeName());
                        try {
                            String rule = declaration.getProperty() + ": " + Botocss.getStringValue(declaration);
                            String existingStyle = element.attr("style");
                            element.attr("style", existingStyle.equals("") ? rule : existingStyle + "; " + rule);
                        }
                        catch (IllegalArgumentException e) {
                            log.warn("Failed to process CSS property value: " + e.getMessage());
                        }
                    }
                }
            }
        }
        return selectorCount;
    }

    private static List<Element> findElements(Document document, CombinedSelector selector) {
        try {
            return document.select(selector.toString());
        }
        catch (Selector.SelectorParseException e) {
            log.info("Skipping unsupported selector: " + selector.toString());
            return Collections.emptyList();
        }
    }

    private static String getStringValue(Declaration declaration) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < declaration.size(); ++i) {
            Term term = (Term)declaration.get(i);
            if (i > 0) {
                result.append(term.getOperator().value());
            }
            result.append(Botocss.getStringValue(term));
        }
        return result.toString();
    }

    private static String getStringValue(Term<?> term) {
        if (term instanceof TermIdent) {
            return (String)term.getValue();
        }
        if (term instanceof TermString) {
            return "'" + ((String)term.getValue()).replaceAll("'", "\\\\'") + "'";
        }
        if (term instanceof TermNumber) {
            return Botocss.formatNumber(((Float)((TermNumber)term).getValue()).floatValue());
        }
        if (term instanceof TermLength || term instanceof TermAngle || term instanceof TermTime) {
            TermNumeric length = (TermNumeric)term;
            return Botocss.formatNumber(((Float)length.getValue()).floatValue()) + length.getUnit().value();
        }
        if (term instanceof TermPercent) {
            return Botocss.formatNumber(((Float)((TermPercent)term).getValue()).floatValue()) + "%";
        }
        if (term instanceof TermFunction) {
            TermFunction function = (TermFunction)term;
            return function.getFunctionName() + "(" + Joiner.on((String)"").join((Iterable)function) + ")";
        }
        if (term instanceof TermColor) {
            Color color = (Color)((TermColor)term).getValue();
            String hex = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            return CAN_SHORTEN_COLOR_PATTERN.matcher(hex).replaceAll(SHORTEN_COLOR_REPLACEMENT);
        }
        if (term instanceof TermURI) {
            return "url(" + term.getValue() + ")";
        }
        throw new IllegalArgumentException("Unrecognised CSS value: " + term.toString() + " (" + term.getClass() + ")");
    }

    private static String formatNumber(float value) {
        if ((double)value == Math.ceil(value)) {
            return String.valueOf(Math.round(value));
        }
        return String.format("%.3f", Float.valueOf(value));
    }
}

