(function(window) {
    /* global require: true, define: true */

    'use strict';

    // Almond claims to be AMD compatible, but isn't.
    delete define.amd;


    //  List of special cases in our AMD shims
    var whitelistedInternalModules = [
        'bitbucket/internal/feature/pull-request/can-merge/can-merge',
        'bitbucket/internal/feature/repository/branch-multi-selector/branch-multi-selector',
        'bitbucket/internal/feature/repository/global-repository-selector/global-repository-selector',
        'bitbucket/internal/feature/repository/revision-reference-selector/revision-reference-selector',
        'bitbucket/internal/feature/user/group-multi-selector/group-multi-selector',
        'bitbucket/internal/feature/user/user-multi-selector/user-multi-selector',
        'bitbucket/internal/util/dom-event',
        'bitbucket/internal/util/events',
        'bitbucket/internal/util/time',
        'bitbucket/internal/widget/avatar-picker-dialog/avatar-picker-dialog',
        'bitbucket/internal/widget/searchable-multi-selector/searchable-multi-selector',
        'bitbucket/internal/util/client-storage',
        'bitbucket/internal/feature/alerts/alerts',
        'bitbucket/internal/bbui/pull-request-list-table/pull-request-list-table',
        'bitbucket/internal/bbui/pull-request-list-table/components/summary',
    ];

    function isWhitelisted(dep) {
        return whitelistedInternalModules.indexOf(dep) !== -1;
    }

    function makeInternalUseMessage(name, deps, willRemove) {
        return (name === 'require' ?
            "Internal modules "  + deps.join(', ') +  " must not be require()'d." :
            'AMD module ' + name + ' must not depend on internal module(s) ' + deps.join(', ') + '. ')  +
            (willRemove ? 'This will stop working in Bitbucket Server 7.0. ' : '') +
            'See the API changelog for details: ' +
            'https://developer.atlassian.com/server/bitbucket/reference/api-changelog/#expected-future-changes';
    }

    function throwOnInternalUse(name, deps) {
        var isInternal = (name.indexOf('bitbucket/') === 0 ||
            name.indexOf('bitbucket-plugin-') === 0
        );

        if (!isInternal) {
            var restrictedDeps = deps.filter(function (dep) {
                return dep.indexOf('bitbucket/internal') === 0;
            });
            if (restrictedDeps.length > 0) {
                var warnings = restrictedDeps.filter(function (dep) {
                    return isWhitelisted(dep);
                });
                if (warnings.length) {
                    console.error(makeInternalUseMessage(name, warnings, true));
                }
                if (warnings.length !== restrictedDeps.length) { // in the common case, everything will be a warning, so short-circuit.
                    var errors = restrictedDeps.filter(function (dep) {
                        return !isWhitelisted(dep);
                    });
                    throw new Error(makeInternalUseMessage(name, errors));
                }
            }
        }
    }

    var oldRequire = require;
    var logged = false;
    require = function(modules, cb) {
        if (typeof modules === 'string' && typeof cb === 'function') {
            if (!logged) {
                logged = true;
                console.log('WARN: require(string, function) has been deprecated in 2.11 and will throw an error' +
                    ' in 6.0. Use an array of dependencies - require(Array<string> function). (requiring '  + modules + ')');
            }
            modules = [modules];
        }

        // to enable this, I have to refactor us away from using HTML as our starting point and instead have JS as our starting point.
        //
        //if (false && modules) {
        //    throwOnInternalUse('require', Array.isArray(modules) ? modules : [modules]);
        //}

        //only allow the use of a callback as the second param, don't expose any other almond internal params.
        //https://github.com/requirejs/almond/blob/0.3.0/almond.js#L337
        if (cb && typeof cb !== 'function') {
            cb = undefined;
        }
        return oldRequire.call(window, modules, cb);
    };

    var oldDefine = define;
    define = function(name, deps, callback) {
        // duplicate logic from Almond to check if deps is a callback (ie. no dependencies)
        if (!deps.splice) {
            //deps is not an array, so probably means
            //an object literal or factory function for
            //the value. Adjust args.
            callback = deps;
            deps = [];
        }

        throwOnInternalUse(name, deps);

        var requireIndex = deps.indexOf('require');
        if (requireIndex !== -1) {
            var oldCallback = callback;
            callback = function() {
                var oldRequire = arguments[requireIndex];
                arguments[requireIndex] = function(modules) {
                    if (modules) {
                        throwOnInternalUse(name, Array.isArray(modules) ? modules : [modules]);
                    }
                    return oldRequire.apply(this, arguments);
                };
                return oldCallback.apply(this, arguments);
            };
        }

        return oldDefine.call(window, name, deps, callback);
    };

    window.requireLite = require; // Used for testing
    window.defineLite = define; // Used for testing
})(window || this);
