define('bitbucket/internal/widget/tree-view/tree-view', ['exports', 'prop-types', 'react', './components/default-leaf', './components/default-node', './components/default-node-label', './components/default-nodes'], function (exports, _propTypes, _react, _defaultLeaf, _defaultNode, _defaultNodeLabel, _defaultNodes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.DefaultLeaf = exports.DefaultNodeLabel = exports.DefaultNode = exports.DefaultNodes = undefined;
    exports.renderTree = renderTree;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _defaultLeaf2 = _interopRequireDefault(_defaultLeaf);

    var _defaultNode2 = _interopRequireDefault(_defaultNode);

    var _defaultNodeLabel2 = _interopRequireDefault(_defaultNodeLabel);

    var _defaultNodes2 = _interopRequireDefault(_defaultNodes);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    function renderTree(components) {
        var NodeComponent = components.NodeComponent;


        return function renderNodes(nodes) {
            return nodes.map(function (_ref) {
                var childNodes = _ref.children,
                    node = _objectWithoutProperties(_ref, ['children']);

                var id = node.id;

                var props = _extends({}, node, components);

                return _react2.default.createElement(
                    NodeComponent,
                    _extends({}, props, { key: id }),
                    renderNodes(childNodes)
                );
            });
        };
    }

    var TreeView = function (_PureComponent) {
        _inherits(TreeView, _PureComponent);

        function TreeView() {
            _classCallCheck(this, TreeView);

            return _possibleConstructorReturn(this, (TreeView.__proto__ || Object.getPrototypeOf(TreeView)).apply(this, arguments));
        }

        _createClass(TreeView, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    tree = _props.tree,
                    className = _props.className,
                    components = _objectWithoutProperties(_props, ['tree', 'className']);

                var NodesComponent = components.NodesComponent;


                var rootNodes = tree.children;
                var treeView = renderTree(components)(rootNodes);

                return _react2.default.createElement(
                    'div',
                    { className: className },
                    _react2.default.createElement(
                        NodesComponent,
                        { isRoot: true },
                        treeView
                    )
                );
            }
        }]);

        return TreeView;
    }(_react.PureComponent);

    TreeView.propTypes = {
        tree: _propTypes2.default.object.isRequired,
        NodesComponent: _propTypes2.default.func,
        NodeComponent: _propTypes2.default.func,
        NodeLabelComponent: _propTypes2.default.func,
        LeafComponent: _propTypes2.default.func,
        className: _propTypes2.default.string
    };
    TreeView.defaultProps = {
        NodesComponent: _defaultNodes2.default,
        NodeComponent: _defaultNode2.default,
        NodeLabelComponent: _defaultNodeLabel2.default,
        LeafComponent: _defaultLeaf2.default,
        className: null
    };
    exports.default = TreeView;
    exports.DefaultNodes = _defaultNodes2.default;
    exports.DefaultNode = _defaultNode2.default;
    exports.DefaultNodeLabel = _defaultNodeLabel2.default;
    exports.DefaultLeaf = _defaultLeaf2.default;
});