define("bitbucket/internal/util/timer", ["exports"], function (exports) {
    "use strict";

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    var timers = {};

    var startTimer = exports.startTimer = function startTimer(key) {
        var startTime = performance.now();

        if (timers[key]) {
            throw new Error("Timer already started with key: " + key);
        }

        timers[key] = startTime;
    };

    var endTimer = exports.endTimer = function endTimer(key) {
        var endTime = performance.now();
        var startTime = timers[key];

        if (!startTime) {
            throw new Error("No timer exists with key: " + key);
        }
        delete timers[key];

        return endTime - startTime;
    };
});