define('bitbucket/internal/util/store/store', ['exports', 'lodash', 'redux'], function (exports, _lodash, _redux) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._makeStore = undefined;

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || _redux.compose;

    var makeStore = function makeStore() {
        var reducers = {};
        var actors = [];

        var actorMiddleware = function actorMiddleware(store) {
            return function (next) {
                return function (action) {
                    // actors are provided with a picture of the world before the action is applied
                    var preActionState = store.getState();

                    // release the action to reducers before firing additional actions
                    var result = next(action);

                    // if no previous state - use the current state;
                    var postActionState = store.getState();

                    // synchronously call actors
                    actors.forEach(function (actor) {
                        return actor(action, store.dispatch, preActionState, postActionState);
                    });

                    return result;
                };
            };
        };

        var store = (0, _redux.createStore)(function () {}, {}, composeEnhancers((0, _redux.applyMiddleware)(actorMiddleware)));

        /**
         * Extend the store with new reducers.
         * @param newReducers
         */
        store.addReducers = function (newReducers) {
            var clashingReducers = (0, _lodash.intersection)(Object.keys(reducers), Object.keys(newReducers)).filter(function (clashingKey) {
                return reducers[clashingKey] !== newReducers[clashingKey];
            });

            if (clashingReducers.length) {
                throw new Error('The following new reducers would clash with existing reducers: ' + clashingReducers.toString());
            }

            reducers = _extends({}, reducers, newReducers);
            store.replaceReducer((0, _redux.combineReducers)(reducers));
            store.dispatch({ type: '___RE_INIT__' });
            // Ensure the new reducers have their initial state set. The actual type is not important
            // Redux would do this by itself, but the react-devtools-extension interferes with it if they are present,
            // so for consistent behaviour we explicitly force it.
        };

        /**
         * Add new actors to the store
         * @param {...function | function[]} newActors
         */
        store.addActors = function () {
            for (var _len = arguments.length, newActors = Array(_len), _key = 0; _key < _len; _key++) {
                newActors[_key] = arguments[_key];
            }

            //Allow passing actors as an array or multiple args
            if (newActors.length === 1 && (0, _lodash.isArray)(newActors[0])) {
                newActors = newActors[0];
            }

            newActors.forEach(function (actor) {
                if (!actors.includes(actor)) {
                    actors.push(actor);
                }
            });
        };

        return store;
    };

    //The dynamic store is a singleton created the first time something asks for it.
    exports.default = (0, _lodash.once)(makeStore);
    exports._makeStore = makeStore;
});