define('bitbucket/internal/util/store/project', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', './reducers', './selectors', './store'], function (exports, _lodash, _redux, _reselect, _navbuilder, _server, _enums, _entity, _restActor, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _restActorsForTypes, _combineReducers;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();

    var APP_NAME = _enums.Entity.PROJECT;

    /* ACTIONS */
    var LOAD = 'LOAD_PROJECT';
    var LOAD_SUCCESS = 'LOAD_PROJECT_SUCCESS';
    var LOAD_FAILURE = 'LOAD_PROJECT_FAILURE';
    var LOAD_PAGE = 'LOAD_PROJECTS';
    var LOAD_PAGE_SUCCESS = 'LOAD_PROJECTS_SUCCESS';
    var LOAD_PAGE_FAILURE = 'LOAD_PROJECTS_FAILURE';
    var SAVE = 'SAVE_PROJECT';
    var SAVE_SUCCESS = 'SAVE_PROJECT_SUCCESS';
    var SAVE_FAILURE = 'SAVE_PROJECT_FAILURE';
    var SET_ENTITY = 'SET_PROJECT';

    var requestTypes = {
        ALL: 'ALL'
    };

    var actors = (0, _restActor.restActorsForTypes)((_restActorsForTypes = {}, _defineProperty(_restActorsForTypes, LOAD, function (_ref) {
        var project = _ref.payload;
        return {
            url: _navbuilder2.default.rest().project(project).build()
        };
    }), _defineProperty(_restActorsForTypes, SAVE, function (_ref2) {
        var project = _ref2.payload;
        return {
            url: _navbuilder2.default.rest().project(project).build(),
            type: _server.method.PUT,
            data: project
        };
    }), _defineProperty(_restActorsForTypes, LOAD_PAGE, function (action, state) {
        var requestInfo = getRequestInfo(action)(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        if ((0, _lodash.get)(requestInfo, 'pagingMeta.isLastPage')) {
            throw new Error('Cannot request beyond the last page');
        }

        var start = (0, _lodash.get)(requestInfo, 'pagingMeta.nextPageStart', 0);

        var _action$payload = action.payload,
            filter = _action$payload.filter,
            permission = _action$payload.permission,
            _action$payload$limit = _action$payload.limit,
            limit = _action$payload$limit === undefined ? (0, _lodash.get)(requestInfo, 'pagingMeta.limit', _restActor.DEFAULT_PAGE_SIZE) : _action$payload$limit;


        return {
            url: _navbuilder2.default.rest().projects().withDefinedParams({
                avatarSize: _enums.AvatarSize.SMALL,
                name: filter,
                permission: permission,
                limit: limit,
                start: start
            }).build()
        };
    }), _restActorsForTypes));

    store.addActors(actors);

    var requestTypeKeyProps = _defineProperty({}, requestTypes.ALL, ['filter', 'permission']);

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.entitiesReducer)({
            loadPageSuccess: [LOAD_PAGE_SUCCESS],
            loadSingleSuccess: [LOAD_SUCCESS, SAVE_SUCCESS, SET_ENTITY]
        }, _entity.getProjectId),
        requests: (0, _redux.combineReducers)((_combineReducers = {}, _defineProperty(_combineReducers, LOAD, (0, _reducers.singleEntityRequestReducer)({
            start: LOAD,
            end: [LOAD_FAILURE, LOAD_SUCCESS],
            getId: _entity.getProjectId
        })), _defineProperty(_combineReducers, SAVE, (0, _reducers.singleEntityRequestReducer)({
            start: [SAVE],
            end: [SAVE_FAILURE, SAVE_SUCCESS],
            getId: _entity.getProjectId
        })), _defineProperty(_combineReducers, LOAD_PAGE, (0, _reducers.getRequestPageReducersByType)({
            requestTypeKeyProps: requestTypeKeyProps,
            getId: _entity.getProjectId,
            LOAD_PAGE: LOAD_PAGE,
            LOAD_PAGE_FAILURE: LOAD_PAGE_FAILURE,
            LOAD_PAGE_SUCCESS: LOAD_PAGE_SUCCESS
        })), _combineReducers))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadProject: function loadProject(minimalProject) {
            return {
                type: LOAD,
                payload: minimalProject,
                meta: {
                    successType: LOAD_SUCCESS,
                    failureType: LOAD_FAILURE
                }
            };
        },
        saveProject: function saveProject(project) {
            return {
                type: SAVE,
                payload: project,
                meta: {
                    successType: SAVE_SUCCESS,
                    failureType: SAVE_FAILURE
                }
            };
        },
        setProject: function setProject(project) {
            return {
                type: SET_ENTITY,
                payload: project
            };
        },
        loadProjects: function loadProjects(_ref3) {
            var filter = _ref3.filter,
                permission = _ref3.permission,
                limit = _ref3.limit;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.ALL,
                    filter: filter,
                    permission: permission,
                    limit: limit
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: _entity.getProjectId,
        requestTypeKeyProps: requestTypeKeyProps
    }),
        getEntity = _getSelectorsForApp.getEntity,
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getEntitiesForRequest = _getSelectorsForApp.getEntitiesForRequest,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getAllFetchedForRequest = _getSelectorsForApp.getAllFetchedForRequest;

    var selectors = exports.selectors = {
        getProject: getEntity,
        getProjectLoading: function getProjectLoading(minimalProjectSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([minimalProjectSelector], actionCreators.loadProject));
        },
        getProjectSaving: function getProjectSaving(projectSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([projectSelector], actionCreators.loadProject));
        },
        getProjects: function getProjects(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadProjects));
        },
        getProjectsLoading: function getProjectsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadProjects));
        },
        getProjectsAllFetched: function getProjectsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadProjects));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});