define('bitbucket/internal/util/store/commit', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', './reducers', './selectors', './store'], function (exports, _lodash, _redux, _reselect, _navbuilder, _server, _enums, _entity, _restActor, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _restActorsForTypes, _requestTypeKeyProps, _combineReducers;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();
    var APP_NAME = _enums.Entity.COMMIT;

    var requestTypes = {
        COMPARE: 'COMPARE',
        PULL_REQUEST: _enums.Entity.PULL_REQUEST,
        REPOSITORY: _enums.Entity.REPOSITORY
    };

    /* ACTIONS */
    var LOAD = 'LOAD_COMMIT';
    var LOAD_SUCCESS = 'LOAD_COMMIT_SUCCESS';
    var LOAD_FAILURE = 'LOAD_COMMIT_FAILURE';
    var LOAD_PAGE = 'LOAD_COMMITS';
    var LOAD_PAGE_SUCCESS = 'LOAD_COMMITS_SUCCESS';
    var LOAD_PAGE_FAILURE = 'LOAD_COMMITS_FAILURE';
    var SET_ENTITY = 'SET_COMMIT';

    var actors = (0, _restActor.restActorsForTypes)((_restActorsForTypes = {}, _defineProperty(_restActorsForTypes, LOAD, function (_ref) {
        var _ref$payload = _ref.payload,
            repository = _ref$payload.repository,
            commit = _ref$payload.commit;
        return {
            url: _navbuilder2.default.rest().repository(repository).commit(commit.id).withParams({ avatarSize: _enums.AvatarSize.SMALL }).build()
        };
    }), _defineProperty(_restActorsForTypes, LOAD_PAGE, function (action, state) {
        var requestInfo = getRequestInfo(function () {
            return action;
        })(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        if ((0, _lodash.get)(requestInfo, 'pagingMeta.isLastPage')) {
            throw new Error('Cannot request beyond the last page');
        }

        var start = (0, _lodash.get)(requestInfo, 'pagingMeta.nextPageStart', 0);

        var _action$payload = action.payload,
            requestType = _action$payload.requestType,
            followRenames = _action$payload.followRenames,
            from = _action$payload.from,
            fromRepo = _action$payload.fromRepo,
            ignoreMissing = _action$payload.ignoreMissing,
            _action$payload$limit = _action$payload.limit,
            limit = _action$payload$limit === undefined ? (0, _lodash.get)(requestInfo, 'pagingMeta.limit', _restActor.DEFAULT_PAGE_SIZE) : _action$payload$limit,
            merges = _action$payload.merges,
            path = _action$payload.path,
            pullRequest = _action$payload.pullRequest,
            repository = _action$payload.repository,
            since = _action$payload.since,
            to = _action$payload.to,
            until = _action$payload.until,
            withCounts = _action$payload.withCounts;


        var urlBuilder = void 0;

        switch (requestType) {
            case requestTypes.COMPARE:
                urlBuilder = _navbuilder2.default.rest().repository(repository).compare().commits().withDefinedParams({ from: from, to: to, fromRepo: fromRepo });
                break;
            case requestTypes.REPOSITORY:
                urlBuilder = _navbuilder2.default.rest().repository(repository).commits().withDefinedParams({
                    followRenames: followRenames,
                    ignoreMissing: ignoreMissing,
                    merges: merges,
                    path: path,
                    since: since,
                    until: until,
                    withCounts: withCounts
                });
                break;
            case requestTypes.PULL_REQUEST:
                urlBuilder = _navbuilder2.default.rest().pullRequest(pullRequest).commits().withDefinedParams({ withCounts: withCounts });
                break;
            default:
                throw new Error('Invalid request type');
        }

        return {
            url: urlBuilder.withParams({ avatarSize: _enums.AvatarSize.SMALL, limit: limit, start: start }).build()
        };
    }), _restActorsForTypes));

    store.addActors(actors);

    var requestTypeKeyProps = (_requestTypeKeyProps = {}, _defineProperty(_requestTypeKeyProps, requestTypes.COMPARE, [['repository', _entity.getRepositoryId], 'from', 'fromRepo', 'limit', 'repository', 'to']), _defineProperty(_requestTypeKeyProps, requestTypes.PULL_REQUEST, [['pullRequest', _entity.getPullRequestId], 'pullRequest.fromRef.latestCommit', 'pullRequest.toRef.latestCommit', 'withCounts']), _defineProperty(_requestTypeKeyProps, requestTypes.REPOSITORY, [['repository', _entity.getRepositoryId], 'followRenames', 'ignoreMissing', 'merges', 'path', 'repository', 'since', 'until', 'withCounts']), _requestTypeKeyProps);

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.entitiesReducer)({
            loadPageSuccess: [LOAD_PAGE_SUCCESS],
            loadSingleSuccess: [LOAD_SUCCESS, SET_ENTITY]
        }, _entity.getCommitId),
        requests: (0, _redux.combineReducers)((_combineReducers = {}, _defineProperty(_combineReducers, LOAD, (0, _reducers.singleEntityRequestReducer)({
            start: LOAD,
            end: [LOAD_FAILURE, LOAD_SUCCESS],
            getId: _entity.getCommitId
        })), _defineProperty(_combineReducers, LOAD_PAGE, (0, _reducers.getRequestPageReducersByType)({
            requestTypeKeyProps: requestTypeKeyProps,
            getId: _entity.getCommitId,
            LOAD_PAGE: LOAD_PAGE,
            LOAD_PAGE_FAILURE: LOAD_PAGE_FAILURE,
            LOAD_PAGE_SUCCESS: LOAD_PAGE_SUCCESS
        })), _combineReducers))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadCommit: function loadCommit(_ref2) {
            var repository = _ref2.repository,
                commit = _ref2.commit;
            return {
                type: LOAD,
                payload: { repository: repository, commit: commit },
                meta: {
                    successType: LOAD_SUCCESS,
                    failureType: LOAD_FAILURE
                }
            };
        },
        setCommit: function setCommit(commit) {
            return {
                type: SET_ENTITY,
                payload: commit
            };
        },
        loadCompareCommits: function loadCompareCommits(_ref3) {
            var repository = _ref3.repository,
                from = _ref3.from,
                fromRepo = _ref3.fromRepo,
                limit = _ref3.limit,
                to = _ref3.to;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.COMPARE,
                    from: from,
                    fromRepo: fromRepo,
                    limit: limit,
                    repository: repository,
                    to: to
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadPullRequestCommits: function loadPullRequestCommits(_ref4) {
            var limit = _ref4.limit,
                pullRequest = _ref4.pullRequest,
                _ref4$withCounts = _ref4.withCounts,
                withCounts = _ref4$withCounts === undefined ? true : _ref4$withCounts;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.PULL_REQUEST,
                    limit: limit,
                    pullRequest: pullRequest,
                    withCounts: withCounts
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadRepositoryCommits: function loadRepositoryCommits(_ref5) {
            var followRenames = _ref5.followRenames,
                ignoreMissing = _ref5.ignoreMissing,
                limit = _ref5.limit,
                merges = _ref5.merges,
                path = _ref5.path,
                repository = _ref5.repository,
                since = _ref5.since,
                until = _ref5.until,
                withCounts = _ref5.withCounts;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.REPOSITORY,
                    followRenames: followRenames,
                    ignoreMissing: ignoreMissing,
                    limit: limit,
                    merges: merges,
                    path: path,
                    repository: repository,
                    since: since,
                    until: until,
                    withCounts: withCounts
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: _entity.getCommitId,
        requestTypeKeyProps: requestTypeKeyProps
    }),
        getEntity = _getSelectorsForApp.getEntity,
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getEntitiesForRequest = _getSelectorsForApp.getEntitiesForRequest,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getAllFetchedForRequest = _getSelectorsForApp.getAllFetchedForRequest;

    var selectors = exports.selectors = {
        getCommit: getEntity,
        getCommitLoading: function getCommitLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCommit));
        },

        getPullRequestCommits: function getPullRequestCommits(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestCommits));
        },
        getPullRequestCommitsLoading: function getPullRequestCommitsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestCommits));
        },
        getPullRequestCommitsAllFetched: function getPullRequestCommitsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestCommits));
        },

        getRepositoryCommits: function getRepositoryCommits(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryCommits));
        },
        getRepositoryCommitsLoading: function getRepositoryCommitsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryCommits));
        },
        getRepositoryCommitsAllFetched: function getRepositoryCommitsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryCommits));
        },

        getCompareCommits: function getCompareCommits(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCompareCommits));
        },
        getCompareCommitsLoading: function getCompareCommitsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCompareCommits));
        },
        getCompareCommitsAllFetched: function getCompareCommitsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadCompareCommits));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});