define('bitbucket/internal/route/pull-requests/pull-request-list-route', ['exports', 'react', 'react-redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/route', 'bitbucket/internal/util/store/repository', 'bitbucket/internal/util/store/selectors'], function (exports, _react, _reactRedux, _reselect, _navbuilder, _entity, _route, _repository, _selectors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.PullRequestListRoute = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    //Dummmy component for now
    var PullRequestList = function PullRequestList(props) {
        console.log(props);
        return _react2.default.createElement(
            'h1',
            null,
            'Pull Request List'
        );
    };

    var PullRequestListRoute = exports.PullRequestListRoute = function (_PureComponent) {
        _inherits(PullRequestListRoute, _PureComponent);

        function PullRequestListRoute() {
            _classCallCheck(this, PullRequestListRoute);

            return _possibleConstructorReturn(this, (PullRequestListRoute.__proto__ || Object.getPrototypeOf(PullRequestListRoute)).apply(this, arguments));
        }

        _createClass(PullRequestListRoute, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadRepositoryIfNecessary();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.loadRepositoryIfNecessary();
            }
        }, {
            key: 'loadRepositoryIfNecessary',
            value: function loadRepositoryIfNecessary() {
                var _props = this.props,
                    repository = _props.repository,
                    repositoryLoading = _props.repositoryLoading,
                    loadRepository = _props.loadRepository,
                    projectKey = _props.projectKey,
                    repoSlug = _props.repoSlug;


                if (!repository && !repositoryLoading) {
                    loadRepository((0, _entity.buildMinimalRepository)(projectKey, repoSlug));
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    repository = _props2.repository,
                    repositoryLoading = _props2.repositoryLoading;


                if (repositoryLoading) {
                    return _react2.default.createElement(
                        'h1',
                        null,
                        'LOADING'
                    );
                }

                if (!repository) {
                    return null;
                }

                return _react2.default.createElement(PullRequestList, { repository: repository /*filter props*/ });
            }
        }]);

        return PullRequestListRoute;
    }(_react.PureComponent);

    var minimalRepositoryFromProps = (0, _selectors.filteredPropsSelector)(['projectKey', 'repoSlug'], _entity.buildMinimalRepository);

    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        repository: _repository.selectors.getRepository(minimalRepositoryFromProps),
        repositoryLoading: _repository.selectors.getRepositoryLoading(minimalRepositoryFromProps)
    });

    var mapDispatchToProps = {
        loadRepository: _repository.actionCreators.loadRepository
    };

    exports.default = (0, _route.asRoute)({
        exact: true,
        path: decodeURIComponent(_navbuilder2.default.project(':projectKey').repo(':repoSlug').allPullRequests().build())
    })((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestListRoute));
});