define('bitbucket/internal/page/maintenance/lock/lock', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/util/navbuilder', 'bitbucket/internal/layout/maintenance/maintenance', 'bitbucket/internal/util/ajax', 'bitbucket/internal/widget/submit-spinner/submit-spinner'], function (module, exports, _aui, _jquery, _navbuilder, _maintenance, _ajax, _submitSpinner) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _maintenance2 = _interopRequireDefault(_maintenance);

    var _ajax2 = _interopRequireDefault(_ajax);

    var _submitSpinner2 = _interopRequireDefault(_submitSpinner);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function onReady(hasToken) {
        var pollUrl = AJS.contextPath() + '/mvc/maintenance/lock';
        var cancelButtonId = 'cancel';
        var opts = {
            pollUrl: pollUrl,
            pollTickCallback: function pollTickCallback(progressBar, data, textStatus, xhr) {
                // always return undefined - never done until the pollUrl returns a 404
                return undefined;
            },
            cancelButtonId: cancelButtonId,
            redirectUrl: hasToken ? _navbuilder2.default.admin().build() : _navbuilder2.default.dashboard().build(),
            canceledHeader: AJS.I18n.getText('bitbucket.web.lock.canceled.title', bitbucket.internal.util.productInfo.productInfo.productName()),
            cancelingDescription: AJS.I18n.getText('bitbucket.web.lock.canceling.description', bitbucket.internal.util.productInfo.productInfo.productName()),
            hasCancelDialog: false
        };

        (0, _jquery2.default)('#' + cancelButtonId).on('click', function (event) {
            var $button = (0, _jquery2.default)(this);
            var $form = $button.closest('form');
            var $tokenField = $form.find('input[name=token]');
            var token = $tokenField.val();
            var spinner = new _submitSpinner2.default($button, 'after');

            spinner.show();

            // Can't use data() because jQuery sends the data as content body instead of query string parameters for
            // all non-GET requests. Encode the token into the query string of the url.
            _ajax2.default.rest({
                url: pollUrl + '?token=' + encodeURIComponent(token),
                type: 'DELETE',
                statusCode: {
                    '409': function _(xhr, textStatus, errorThrown, resp) {
                        $tokenField.parent().replaceWith(bitbucket.internal.layout.maintenance.maintenanceClient.tokenInputField(resp));
                        return false;
                    },
                    '*': false
                }
            }).always(function () {
                spinner.hide();
            }).done(function () {
                window.location = opts.redirectUrl;
            });

            event.preventDefault();
        });

        _maintenance2.default.init(opts);
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});