define('bitbucket/internal/next/widget/branch-lozenge/branch-lozenge', ['module', 'exports', '@atlaskit/icon/glyph/chevron-right', '@atlaskit/tooltip', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional', './branch-lozenge.less'], function (module, exports, _chevronRight, _tooltip, _aui, _propTypes, _react, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _chevronRight2 = _interopRequireDefault(_chevronRight);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var formatBranchTitle = function formatBranchTitle(branch) {
        return branch.repository ? branch.repository.project.name + ' / ' + branch.repository.name : branch.displayId;
    };

    var BranchLozenge = function BranchLozenge(_ref) {
        var branch = _ref.branch,
            showRepo = _ref.showRepo,
            icon = _ref.icon;
        return _react2.default.createElement(
            _tooltip2.default,
            { tag: 'span', content: formatBranchTitle(branch) },
            _react2.default.createElement(
                'span',
                { className: 'branch' },
                icon,
                showRepo ? _react2.default.createElement(
                    'span',
                    { className: 'show-repo-and-icon' },
                    branch.repository.name,
                    _react2.default.createElement(_chevronRight2.default, { size: 'small' })
                ) : null,
                branch.displayId
            )
        );
    };

    BranchLozenge.propTypes = {
        branch: _propTypes.object.isRequired,
        showRepo: _propTypes.bool,
        icon: _propTypes.node
    };

    BranchLozenge.defaultProps = {
        showRepo: false
    };

    exports.default = (0, _reactFunctional.pure)(BranchLozenge);
    module.exports = exports['default'];
});