define('bitbucket/internal/next/util/react-i18n', ['exports', '@atlassian/aui', 'react'], function (exports, _aui, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.I18n = undefined;
    exports.format = format;

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    // We need to export the "format" function since it's used during the runtime
    function format(translation) {
        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
        }

        var i = 0;

        var mapping = {};

        args = args.map(function (arg) {
            if ((0, _react.isValidElement)(arg)) {
                var str = '!PLACEHOLDER_' + ++i + '!';

                mapping[str] = arg;

                return str;
            }

            return arg;
        });

        var strParts = _aui.format.apply(undefined, [translation].concat(_toConsumableArray(args))).split(/(!PLACEHOLDER_\d+!)/g);

        if (strParts.length === 1) {
            return strParts.join('');
        }

        var asReactEls = strParts.map(function (str, i) {
            return (
                // eslint-disable-next-line react/no-array-index-key
                _react2.default.createElement(
                    _react.Fragment,
                    { key: i },
                    i % 2 ? mapping[str] : str
                )
            );
        });

        return _react2.default.createElement(
            _react.Fragment,
            null,
            asReactEls
        );
    }

    // We need to re-export the "format" as "getText" since "I18n.getText" it used in the source code and then replaced to
    // "format" by either jsI18n transformer or webpack *.properties loader
    var fakeGetText = function fakeGetText() {
        console.warn('Call to "getText" function was not replaced with either raw translation or call to "format" function. Have you included the "jsI18n" transformation in Web Resource Manager?');

        return format.apply(undefined, arguments);
    };

    var I18n = exports.I18n = {
        getText: fakeGetText
    };
});