define('bitbucket/internal/next/feature/pull-request/pull-request-reviewers/pull-request-reviewer-status/pull-request-reviewer-status', ['module', 'exports', '@atlaskit/button', '@atlaskit/icon/glyph/check-circle', '@atlaskit/icon/glyph/presence-busy', '@atlaskit/tooltip', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/components/react-functional', './pull-request-reviewer-status.less'], function (module, exports, _button, _checkCircle, _presenceBusy, _tooltip, _aui, _classnames, _propTypes, _react, _enums, _reactFunctional, _pullRequestReviewerStatus) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _button2 = _interopRequireDefault(_button);

    var _checkCircle2 = _interopRequireDefault(_checkCircle);

    var _presenceBusy2 = _interopRequireDefault(_presenceBusy);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var ApproveButton = (0, _reactFunctional.pure)(function (_ref) {
        var status = _ref.status,
            onStatusClick = _ref.onStatusClick;

        var isSelected = _enums.ApprovalStatus.APPROVED === status;
        var title = isSelected ? _aui.I18n.getText('bitbucket.web.pullrequest.reviewer.status.tooltip.approve.deselect') : _aui.I18n.getText('bitbucket.web.pullrequest.reviewer.status.tooltip.approve');

        return _react2.default.createElement(
            _tooltip2.default,
            { hideTooltipOnClick: true, content: title, truncate: true },
            _react2.default.createElement(_button2.default, {
                className: (0, _classnames2.default)('status-button', 'approved', {
                    selected: isSelected
                }),
                iconBefore: _react2.default.createElement(_checkCircle2.default, {
                    size: 'small',
                    primaryColor: isSelected ? _pullRequestReviewerStatus.buttonSecondaryColor : _pullRequestReviewerStatus.approvedPrimaryColor,
                    secondaryColor: isSelected ? _pullRequestReviewerStatus.approvedPrimaryColor : _pullRequestReviewerStatus.buttonSecondaryColor
                }),
                onClick: function onClick() {
                    return onStatusClick(isSelected ? _enums.ApprovalStatus.UNAPPROVED : _enums.ApprovalStatus.APPROVED);
                }
            })
        );
    });

    var NeedsWorkButton = (0, _reactFunctional.pure)(function (_ref2) {
        var status = _ref2.status,
            onStatusClick = _ref2.onStatusClick;

        var isSelected = _enums.ApprovalStatus.NEEDS_WORK === status;
        var title = isSelected ? _aui.I18n.getText('bitbucket.web.pullrequest.reviewer.status.tooltip.needswork.deselect') : _aui.I18n.getText('bitbucket.web.pullrequest.reviewer.status.tooltip.needswork');

        return _react2.default.createElement(
            _tooltip2.default,
            { hideTooltipOnClick: true, content: title, truncate: true },
            _react2.default.createElement(_button2.default, {
                className: (0, _classnames2.default)('status-button', 'needs-work', {
                    selected: isSelected
                }),
                iconBefore: _react2.default.createElement(_presenceBusy2.default, {
                    size: 'medium',
                    primaryColor: isSelected ? _pullRequestReviewerStatus.buttonSecondaryColor : _pullRequestReviewerStatus.needsWorkPrimaryColor,
                    secondaryColor: isSelected ? _pullRequestReviewerStatus.needsWorkPrimaryColor : _pullRequestReviewerStatus.buttonSecondaryColor
                }),
                onClick: function onClick() {
                    return onStatusClick(isSelected ? _enums.ApprovalStatus.UNAPPROVED : _enums.ApprovalStatus.NEEDS_WORK);
                }
            })
        );
    });

    var ReviewerStatus = function ReviewerStatus(_ref3) {
        var status = _ref3.status,
            onStatusClick = _ref3.onStatusClick;
        return _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(NeedsWorkButton, { status: status, onStatusClick: onStatusClick }),
            _react2.default.createElement(ApproveButton, { status: status, onStatusClick: onStatusClick })
        );
    };

    ReviewerStatus.propTypes = {
        status: _propTypes2.default.string.isRequired,
        onStatusClick: _propTypes2.default.func.isRequired
    };

    exports.default = (0, _reactFunctional.pure)(ReviewerStatus);
    module.exports = exports['default'];
});