define('bitbucket/internal/next/feature/pull-request/pull-request-merge/pull-request-merge-store', ['exports', 'icepick', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/pull-request', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/store'], function (exports, _icepick, _lodash, _redux, _reselect, _navbuilder, _server, _enums, _entity, _restActor, _pullRequest, _reducers, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _restActorsForTypes, _combineReducers;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    var store = (0, _store2.default)();

    var APP_NAME = 'PULL_REQUEST_MERGE';

    var pullRequestProp = ['pullRequest', _entity.getPullRequestId];

    /* ACTIONS */
    var LOAD_MERGABLE = 'LOAD_MERGABLE';
    var LOAD_MERGABLE_SUCCESS = 'LOAD_MERGABLE_SUCCESS';
    var LOAD_MERGABLE_FAILURE = 'LOAD_MERGABLE_FAILURE';
    var MERGE = 'MERGE';
    var MERGE_SUCCESS = 'MERGE_SUCCESS';
    var MERGE_FAILURE = 'MERGE_FAILURE';

    /* ACTORS */
    var mergeSuccessActor = function mergeSuccessActor(action, dispatch) {
        if (action.type === MERGE_SUCCESS) {
            dispatch(_pullRequest.actionCreators.setPullRequest(action.payload));
        }
    };

    var actors = [].concat(_toConsumableArray((0, _restActor.restActorsForTypes)((_restActorsForTypes = {}, _defineProperty(_restActorsForTypes, LOAD_MERGABLE, function (_ref, state) {
        var payload = _ref.payload;

        if (selectors.getMergeableLoading(function () {
            return payload.pullRequest;
        })(state)) {
            return null;
        }

        return {
            url: _navbuilder2.default.rest().pullRequest(payload.pullRequest).merge().build()
        };
    }), _defineProperty(_restActorsForTypes, MERGE, function (_ref2) {
        var payload = _ref2.payload;

        return {
            url: _navbuilder2.default.rest().pullRequest(payload.pullRequest).merge().withParams({
                avatarSize: _enums.AvatarSize.SMALL,
                version: payload.pullRequest.version
            }).build(),
            type: _server.method.POST
        };
    }), _restActorsForTypes))), [mergeSuccessActor]);

    store.addActors(actors);

    /* REDUCERS */
    var keyByPullRequest = (0, _reducers.keyByRequestProp)(pullRequestProp);

    var reducer = (0, _redux.combineReducers)({
        mergeable: (0, _reducers.reduceByType)({}, _defineProperty({}, LOAD_MERGABLE_SUCCESS, keyByPullRequest(function () {
            var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
            var action = arguments[1];
            return (0, _icepick.merge)(state, action.payload, _reducers.preserveEqualArrays);
        }))),
        requests: (0, _redux.combineReducers)((_combineReducers = {}, _defineProperty(_combineReducers, LOAD_MERGABLE, (0, _reducers.composeReducers)((0, _reducers.reduceIf)((0, _reducers.actionTypeIn)(LOAD_MERGABLE, LOAD_MERGABLE_FAILURE, LOAD_MERGABLE_SUCCESS)), keyByPullRequest, {
            loading: (0, _reducers.toggleReducer)({
                on: [LOAD_MERGABLE],
                off: [LOAD_MERGABLE_SUCCESS, LOAD_MERGABLE_FAILURE]
            })
        })), _defineProperty(_combineReducers, MERGE, (0, _reducers.composeReducers)((0, _reducers.reduceIf)((0, _reducers.actionTypeIn)(MERGE, MERGE_FAILURE, MERGE_SUCCESS)), keyByPullRequest, {
            loading: (0, _reducers.toggleReducer)({
                on: [MERGE],
                off: [MERGE_SUCCESS, MERGE_FAILURE]
            })
        })), _combineReducers))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadMergeable: function loadMergeable(pullRequest) {
            return {
                type: LOAD_MERGABLE,
                payload: {
                    pullRequest: pullRequest
                },
                meta: {
                    successType: LOAD_MERGABLE_SUCCESS,
                    failureType: LOAD_MERGABLE_FAILURE
                }
            };
        },

        mergePullRequest: function mergePullRequest(pullRequest) {
            return {
                type: MERGE,
                payload: {
                    pullRequest: pullRequest
                },
                meta: {
                    successType: MERGE_SUCCESS,
                    failureType: MERGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */
    var getAppState = function getAppState(state) {
        return (0, _lodash.get)(state, [APP_NAME]);
    };

    var getLoadingForRequest = function getLoadingForRequest(actionSelector) {
        return (0, _reselect.createSelector)([getAppState, actionSelector], function (state, _ref3) {
            var payload = _ref3.payload,
                type = _ref3.type;
            return (0, _lodash.get)(state, ['requests', type, (0, _reducers.getKeyFromProp)(pullRequestProp, payload), 'loading']);
        });
    };

    var getMergeableForRequest = function getMergeableForRequest(actionSelector) {
        return (0, _reselect.createSelector)([getAppState, actionSelector], function (state, _ref4) {
            var payload = _ref4.payload;
            return (0, _lodash.get)(state, ['mergeable', (0, _reducers.getKeyFromProp)(pullRequestProp, payload)]);
        });
    };

    var selectors = exports.selectors = {
        getMergeable: function getMergeable(pullRequestSelector) {
            return getMergeableForRequest((0, _reselect.createSelector)([pullRequestSelector], actionCreators.loadMergeable));
        },

        getMergeableLoading: function getMergeableLoading(pullRequestSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([pullRequestSelector], actionCreators.loadMergeable));
        },

        getMergeLoading: function getMergeLoading(pullRequestSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([pullRequestSelector], actionCreators.mergePullRequest));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});