define('bitbucket/internal/next/feature/pull-request/pull-request-merge/pull-request-merge-conflict-banner', ['module', 'exports', '@atlaskit/section-message', '@atlassian/aui', 'lodash', 'react', 'react-redux', 'reselect', 'bitbucket/internal/enums', 'bitbucket/internal/util/i18n-html', 'bitbucket/internal/util/store/selectors', './pull-request-merge-store'], function (module, exports, _sectionMessage, _aui, _lodash, _react, _reactRedux, _reselect, _enums, _i18nHtml, _selectors, _pullRequestMergeStore) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _sectionMessage2 = _interopRequireDefault(_sectionMessage);

    var _react2 = _interopRequireDefault(_react);

    var _i18nHtml2 = _interopRequireDefault(_i18nHtml);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestMergeConflictBanner = function (_Component) {
        _inherits(PullRequestMergeConflictBanner, _Component);

        function PullRequestMergeConflictBanner() {
            _classCallCheck(this, PullRequestMergeConflictBanner);

            return _possibleConstructorReturn(this, (PullRequestMergeConflictBanner.__proto__ || Object.getPrototypeOf(PullRequestMergeConflictBanner)).apply(this, arguments));
        }

        _createClass(PullRequestMergeConflictBanner, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadMergeable();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                if (prevProps.pullRequest !== this.props.pullRequest) {
                    this.loadMergeable();
                }
            }
        }, {
            key: 'loadMergeable',
            value: function loadMergeable() {
                var _props = this.props,
                    loadMergeable = _props.loadMergeable,
                    pullRequest = _props.pullRequest;


                if (pullRequest.state === _enums.PullRequestState.OPEN) {
                    loadMergeable(pullRequest);
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var mergeable = this.props.mergeable;


                //TODO: The HTML and help urls aren't really working here
                var bitbucket_help_url = function bitbucket_help_url(a) {
                    return a;
                };

                //TODO: fadein
                if ((0, _lodash.get)(mergeable, 'canMerge') === false) {
                    switch ((0, _lodash.get)(mergeable, 'outcome')) {
                        case _enums.MergeOutcome.CONFLICTED:
                            return _react2.default.createElement(
                                _sectionMessage2.default,
                                {
                                    appearance: 'warning',
                                    title: _aui.I18n.getText('bitbucket.web.pullrequest.merge.conflicts')
                                },
                                _react2.default.createElement(
                                    _i18nHtml2.default.p,
                                    { params: ["<a href='#' class='manual-merge'>", '</a>'] },
                                    _aui.I18n.getText('bitbucket.web.pullrequest.merge.conflicts.need.resolving')
                                )
                            );
                        case _enums.MergeOutcome.UNKNOWN:
                            return _react2.default.createElement(
                                _sectionMessage2.default,
                                {
                                    appearance: 'warning',
                                    title: _aui.I18n.getText('bitbucket.web.pullrequest.merge.unknown.title')
                                },
                                _react2.default.createElement(
                                    _i18nHtml2.default.p,
                                    {
                                        params: [bitbucket_help_url('bitbucket.kb.pullrequests.merge.unknown')]
                                    },
                                    _aui.I18n.getText('bitbucket.web.pullrequest.merge.unknown.description')
                                )
                            );
                    }
                }

                return null;
            }
        }]);

        return PullRequestMergeConflictBanner;
    }(_react.Component);

    //CONNECT
    var getPullRequestFromProps = (0, _selectors.singlePropSelector)('pullRequest');

    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        mergeable: _pullRequestMergeStore.selectors.getMergeable(getPullRequestFromProps),
        mergeableLoading: _pullRequestMergeStore.selectors.getMergeableLoading(getPullRequestFromProps)
    });

    var mapDispatchToProps = {
        loadMergeable: _pullRequestMergeStore.actionCreators.loadMergeable,
        mergePullRequest: _pullRequestMergeStore.actionCreators.mergePullRequest
    };

    exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestMergeConflictBanner);
    module.exports = exports['default'];
});