define('bitbucket/internal/next/feature/pull-request/pull-request-merge/merge-dialog/merge-dialog', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/next/widget/avatar/user-avatar', 'bitbucket/internal/util/components/react-functional', '../merge-diagram/connected-merge-diagram', './merge-dialog.less'], function (module, exports, _aui, _propTypes, _react, _userAvatar, _reactFunctional, _connectedMergeDiagram) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _userAvatar2 = _interopRequireDefault(_userAvatar);

    var _connectedMergeDiagram2 = _interopRequireDefault(_connectedMergeDiagram);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var MergeDialog = function MergeDialog(_ref) {
        var pullRequest = _ref.pullRequest;

        var isCrossRepo = pullRequest.toRef.repository.id !== pullRequest.fromRef.repository.id;
        return _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(
                'div',
                { className: 'dialog-header' },
                _react2.default.createElement(_userAvatar2.default, { person: pullRequest.author }),
                _react2.default.createElement(
                    'p',
                    { className: 'commit-message' },
                    'Merge pull request #',
                    pullRequest.id,
                    ' in',
                    ' ',
                    pullRequest.toRef.repository.project.key,
                    '/',
                    pullRequest.toRef.repository.slug,
                    ' ',
                    'from',
                    ' ',
                    isCrossRepo ? pullRequest.fromRef.repository.project.key + '/' + pullRequest.fromRef.repository.slug + ':' : null,
                    pullRequest.fromRef.displayId,
                    ' to ',
                    pullRequest.toRef.displayId
                )
            ),
            _react2.default.createElement(_connectedMergeDiagram2.default, { pullRequest: pullRequest })
        );
    };

    MergeDialog.propTypes = {
        pullRequest: _propTypes.object.isRequired
    };

    exports.default = (0, _reactFunctional.pure)(MergeDialog);
    module.exports = exports['default'];
});