define('bitbucket/internal/next/feature/pull-request/pull-request-merge/merge-button/merge-button', ['module', 'exports', '@atlaskit/button', '@atlaskit/tooltip', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional'], function (module, exports, _button, _tooltip, _aui, _propTypes, _react, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _button2 = _interopRequireDefault(_button);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var MergeButton = function MergeButton(_ref) {
        var disabled = _ref.disabled,
            onClick = _ref.onClick;

        var tooltipContent = disabled ? _aui.I18n.getText('bitbucket.web.pullrequest.merge.issue.tooltip') // TODO: update property when doing BBSDEV-18887, add "Click to know more."
        : '';

        return _react2.default.createElement(
            _tooltip2.default,
            { truncate: true, content: tooltipContent },
            _react2.default.createElement(
                _button2.default,
                { onClick: onClick, isDisabled: disabled },
                _aui.I18n.getText('bitbucket.web.pullrequest.toolbar.merge')
            )
        );
    };

    MergeButton.defaultProps = {
        disabled: true
    };

    MergeButton.propTypes = {
        disabled: _propTypes.bool,
        onClick: _propTypes.func.isRequired
    };

    exports.default = (0, _reactFunctional.pure)(MergeButton);
    module.exports = exports['default'];
});