define('bitbucket/internal/next/feature/diff/diff', ['module', 'exports', '@atlaskit/section-message', '@atlaskit/spinner', '@atlassian/aui', 'classnames', 'lodash', 'react', 'bitbucket/internal/enums', './diff.less'], function (module, exports, _sectionMessage, _spinner, _aui, _classnames, _lodash, _react, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _sectionMessage2 = _interopRequireDefault(_sectionMessage);

    var _spinner2 = _interopRequireDefault(_spinner);

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _segmentTypeLineIndic;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var Diff = function (_PureComponent) {
        _inherits(Diff, _PureComponent);

        function Diff() {
            _classCallCheck(this, Diff);

            return _possibleConstructorReturn(this, (Diff.__proto__ || Object.getPrototypeOf(Diff)).apply(this, arguments));
        }

        _createClass(Diff, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadDiffIfNeeded();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.loadDiffIfNeeded();
            }
        }, {
            key: 'loadDiffIfNeeded',
            value: function loadDiffIfNeeded() {
                var _props = this.props,
                    change = _props.change,
                    fromHash = _props.fromHash,
                    toHash = _props.toHash,
                    diff = _props.diff,
                    diffLoading = _props.diffLoading,
                    repository = _props.repository,
                    loadDiff = _props.loadDiff;


                if (!diff && !diffLoading) {
                    loadDiff({ change: change, fromHash: fromHash, toHash: toHash, repository: repository });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    change = _props2.change,
                    diff = _props2.diff,
                    maxLineNumber = _props2.maxLineNumber;

                return _react2.default.createElement(
                    'div',
                    { className: 'diff-view' },
                    diff ? diff.hunks.length ? diff.hunks.map(function (hunk) {
                        return hunk.segments.map(function (segment) {
                            return segment.lines.map(function (line) {
                                return _react2.default.createElement(DiffLine, {
                                    key: 'line-' + line.source + '-' + line.destination,
                                    line: line,
                                    maxLineNumber: maxLineNumber,
                                    lineType: segment.type,
                                    changeType: change.type
                                });
                            });
                        });
                    }) : _react2.default.createElement(_sectionMessage2.default, {
                        appearance: 'info',
                        title: _aui.I18n.getText('bitbucket.web.repository.diff.nochange.detail')
                    }) : _react2.default.createElement(_spinner2.default, { size: 'large' })
                );
            }
        }]);

        return Diff;
    }(_react.PureComponent);

    exports.default = Diff;

    var DiffLine = function (_PureComponent2) {
        _inherits(DiffLine, _PureComponent2);

        function DiffLine() {
            _classCallCheck(this, DiffLine);

            return _possibleConstructorReturn(this, (DiffLine.__proto__ || Object.getPrototypeOf(DiffLine)).apply(this, arguments));
        }

        _createClass(DiffLine, [{
            key: 'render',
            value: function render() {
                var _props3 = this.props,
                    line = _props3.line,
                    lineType = _props3.lineType,
                    changeType = _props3.changeType,
                    maxLineNumber = _props3.maxLineNumber;


                return _react2.default.createElement(
                    'div',
                    {
                        className: (0, _classnames2.default)('diff-line', {
                            added: lineType === _enums.DiffSegmentTypes.ADDED,
                            removed: lineType === _enums.DiffSegmentTypes.REMOVED,
                            'conflict-marker': line.conflictMarker === _enums.ConflictSegmentTypes.MARKER,
                            'conflict-ours': line.conflictMarker === _enums.ConflictSegmentTypes.OURS,
                            'conflict-theirs': line.conflictMarker === _enums.ConflictSegmentTypes.THEIRS
                        })
                    },
                    _react2.default.createElement(DiffGutter, {
                        line: line,
                        maxLineNumber: maxLineNumber,
                        changeType: changeType,
                        lineType: lineType
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'diff-line-content' },
                        line.line
                    )
                );
            }
        }]);

        return DiffLine;
    }(_react.PureComponent);

    var DiffGutter = function (_PureComponent3) {
        _inherits(DiffGutter, _PureComponent3);

        function DiffGutter() {
            _classCallCheck(this, DiffGutter);

            return _possibleConstructorReturn(this, (DiffGutter.__proto__ || Object.getPrototypeOf(DiffGutter)).apply(this, arguments));
        }

        _createClass(DiffGutter, [{
            key: 'render',
            value: function render() {
                var _props4 = this.props,
                    line = _props4.line,
                    lineType = _props4.lineType,
                    maxLineNumber = _props4.maxLineNumber,
                    changeType = _props4.changeType;


                return _react2.default.createElement(
                    'div',
                    { className: 'diff-gutter' },
                    _react2.default.createElement(DiffLineNumber, {
                        line: line,
                        lineType: lineType,
                        maxLineNumber: maxLineNumber,
                        changeType: changeType
                    })
                );
            }
        }]);

        return DiffGutter;
    }(_react.PureComponent);

    var segmentTypeLineIndicators = (_segmentTypeLineIndic = {}, _defineProperty(_segmentTypeLineIndic, _enums.DiffSegmentTypes.ADDED, '+'), _defineProperty(_segmentTypeLineIndic, _enums.DiffSegmentTypes.CONTEXT, ' '), _defineProperty(_segmentTypeLineIndic, _enums.DiffSegmentTypes.REMOVED, '-'), _segmentTypeLineIndic);

    var DiffLineNumber = function (_PureComponent4) {
        _inherits(DiffLineNumber, _PureComponent4);

        function DiffLineNumber() {
            _classCallCheck(this, DiffLineNumber);

            return _possibleConstructorReturn(this, (DiffLineNumber.__proto__ || Object.getPrototypeOf(DiffLineNumber)).apply(this, arguments));
        }

        _createClass(DiffLineNumber, [{
            key: 'render',
            value: function render() {
                var _props5 = this.props,
                    line = _props5.line,
                    lineType = _props5.lineType,
                    maxLineNumber = _props5.maxLineNumber,
                    changeType = _props5.changeType;

                var maxLineNumberWidth = maxLineNumber.toString().length;
                var lineNumberSegments = [];

                //Hide all source line numbers on added files
                if (changeType !== _enums.ChangeTypes.ADD) {
                    lineNumberSegments.push((0, _lodash.padStart)(lineType !== _enums.DiffSegmentTypes.ADDED ? line.source : '', maxLineNumberWidth));
                }

                //Hide all destination line numbers on removed files
                if (changeType !== _enums.ChangeTypes.DELETE) {
                    lineNumberSegments.push((0, _lodash.padStart)(lineType !== _enums.DiffSegmentTypes.REMOVED ? line.destination : '', maxLineNumberWidth));
                }

                lineNumberSegments.push(segmentTypeLineIndicators[lineType]);

                return _react2.default.createElement(
                    'span',
                    { className: 'diff-line-number' },
                    lineNumberSegments.join(' ')
                );
            }
        }]);

        return DiffLineNumber;
    }(_react.PureComponent);

    module.exports = exports['default'];
});