define('bitbucket/internal/next/feature/diff/diff-store', ['exports', 'icepick', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/selectors', 'bitbucket/internal/util/store/store', './diff-utils'], function (exports, _icepick, _lodash, _redux, _reselect, _navbuilder, _server, _entity, _restActor, _reducers, _selectors, _store, _diffUtils) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._transformDiffsPaths = exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var store = (0, _store2.default)();
    var APP_NAME = 'DIFF';
    var MAX_CONTEXT_LINES = 10000;

    /* ACTIONS */
    var LOAD = 'LOAD_DIFF';
    var LOAD_SUCCESS = 'LOAD_DIFF_SUCCESS';
    var LOAD_FAILURE = 'LOAD_DIFF_FAILURE';

    var transformDiffsPaths = function transformDiffsPaths(diffs) {
        return diffs.map(function (diff) {
            return _extends({}, diff, {
                destination: (0, _lodash.get)(diff, 'destination.toString'),
                source: (0, _lodash.get)(diff, 'source.toString')
            });
        });
    };

    var actors = (0, _restActor.restActorForType)(LOAD, function (_ref) {
        var _nav$rest$repository$;

        var payload = _ref.payload;
        var change = payload.change,
            fromHash = payload.fromHash,
            ignoreWhitespace = payload.ignoreWhitespace,
            toHash = payload.toHash,
            repository = payload.repository;


        //TODO autosrcpath
        // Always fetch the commit diff, as long as we have the correct fromHash and toHash
        // (from the changes list), it doesn't matter what the source is (PR, commit page, compare)
        return {
            url: (_nav$rest$repository$ = _navbuilder2.default.rest().repository(repository).commit(toHash)
            // navbuilder::restDiffInternal expects a fileChange,
            // where `path` and `srcPath` are objects if present.
            // Until we remove all usages of fileChange, we manually build the diff & path url here
            .addPathComponents('diff')).addPathComponents.apply(_nav$rest$repository$, _toConsumableArray(change.path.split('/'))).withDefinedParams({
                contextLines: MAX_CONTEXT_LINES, //Always request max for syntax highlighting
                since: fromHash,
                srcPath: change.srcPath,
                whitespace: ignoreWhitespace ? 'ignore-all' : 'show',
                withComments: false //Enables caching
            }).build()
        };
    }, {
        successTransform: function successTransform(response) {
            return (0, _icepick.set)(response, 'diffs', transformDiffsPaths(response.diffs));
        }
    });

    store.addActors(actors);

    var getDiffId = function getDiffId(_ref2) {
        var change = _ref2.change,
            fromHash = _ref2.fromHash,
            ignoreWhitespace = _ref2.ignoreWhitespace,
            toHash = _ref2.toHash,
            repository = _ref2.repository;

        return [(0, _entity.getRepositoryId)(repository), toHash, fromHash, change.path || '@@_NO_PATH_@@', change.srcPath || '@@_NO_SRCPATH_@@', ignoreWhitespace ? 'ignore-all' : 'show'].join('/');
    };

    var requestProps = [['repository', _entity.getRepositoryId], 'toHash', 'fromHash', 'change.path', 'change.srcPath', 'ignoreWhitespace'];

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.reduceIf)((0, _reducers.actionTypeIn)(LOAD_SUCCESS), {})(function (state, action) {
            var requestPayload = (0, _reducers.getRequestPayload)(action);

            var diffResponse = action.payload;

            return (0, _icepick.set)(state, getDiffId(requestPayload), (0, _diffUtils.getMatchingDiff)({ change: requestPayload.change, diffs: diffResponse.diffs }));
        }),
        requests: (0, _redux.combineReducers)(_defineProperty({}, LOAD, (0, _reducers.composeReducers)((0, _reducers.reduceIf)((0, _reducers.actionTypeIn)(LOAD, LOAD_FAILURE, LOAD_SUCCESS)), (0, _reducers.keyByRequestProps)(requestProps), {
            loading: (0, _reducers.toggleReducer)({
                on: [LOAD],
                off: [LOAD_FAILURE, LOAD_SUCCESS]
            })
        })))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadDiff: function loadDiff(_ref3) {
            var change = _ref3.change,
                fromHash = _ref3.fromHash,
                ignoreWhitespace = _ref3.ignoreWhitespace,
                toHash = _ref3.toHash,
                repository = _ref3.repository;
            return {
                type: LOAD,
                payload: { change: change, fromHash: fromHash, ignoreWhitespace: ignoreWhitespace, toHash: toHash, repository: repository },
                meta: {
                    successType: LOAD_SUCCESS,
                    failureType: LOAD_FAILURE
                }
            };
        }
    };

    /* SELECTORS */
    var getAppState = function getAppState(state) {
        return (0, _lodash.get)(state, APP_NAME);
    };

    var getEntities = (0, _reselect.createSelector)([getAppState], function (appState) {
        return (0, _lodash.get)(appState, 'entities');
    });

    var getLoadingForRequest = function getLoadingForRequest(actionSelector) {
        return (0, _reselect.createSelector)([getAppState, actionSelector], function (state, _ref4) {
            var payload = _ref4.payload,
                type = _ref4.type;

            return (0, _lodash.get)(state, ['requests', type].concat(_toConsumableArray((0, _selectors.keyPathForProps)(requestProps, payload)), ['loading']), false);
        });
    };

    var getDiff = function getDiff(requestParamsSelector) {
        return (0, _reselect.createSelector)([getEntities, requestParamsSelector], function (entities, requestParams) {
            return entities[getDiffId(requestParams)];
        });
    };

    var selectors = exports.selectors = {
        getDiff: getDiff,
        getDiffMaxLineNumber: function getDiffMaxLineNumber(requestParamsSelector) {
            return (0, _reselect.createSelector)([getDiff(requestParamsSelector)], function (diff) {
                return diff && (0, _diffUtils.getMaxLineNumber)(diff);
            });
        },
        getDiffLoading: function getDiffLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadDiff));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
    exports._transformDiffsPaths = transformDiffsPaths;
});