define('bitbucket/internal/next/feature/changes/changes', ['module', 'exports', 'lodash', 'react', 'bitbucket/internal/next/feature/change/change', './changes-sidebar/changes-sidebar', './changes.less'], function (module, exports, _lodash, _react, _change, _changesSidebar) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _change2 = _interopRequireDefault(_change);

    var _changesSidebar2 = _interopRequireDefault(_changesSidebar);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var Changes = function (_PureComponent) {
        _inherits(Changes, _PureComponent);

        function Changes() {
            _classCallCheck(this, Changes);

            return _possibleConstructorReturn(this, (Changes.__proto__ || Object.getPrototypeOf(Changes)).apply(this, arguments));
        }

        _createClass(Changes, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadChangesIfNecessary();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.loadChangesIfNecessary();
            }
        }, {
            key: 'loadChangesIfNecessary',
            value: function loadChangesIfNecessary() {
                var _props = this.props,
                    changes = _props.changes,
                    loading = _props.loading,
                    allFetched = _props.allFetched,
                    loadChanges = _props.loadChanges,
                    commit = _props.commit,
                    sinceCommitId = _props.sinceCommitId,
                    pullRequest = _props.pullRequest;


                if (!changes.length && !loading && !allFetched) {
                    loadChanges({ pullRequest: pullRequest, commit: commit, sinceCommitId: sinceCommitId });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    pullRequest = _props2.pullRequest,
                    repository = _props2.repository,
                    commit = _props2.commit,
                    sinceCommitId = _props2.sinceCommitId,
                    changes = _props2.changes,
                    change = _props2.change,
                    fromHash = _props2.fromHash,
                    toHash = _props2.toHash;


                if (!changes.length) {
                    //TODO: Need to handle edge case where the context (PR, compare, commit) legit has no changes
                }

                return _react2.default.createElement(
                    'div',
                    { className: 'changes' },
                    _react2.default.createElement(_changesSidebar2.default, {
                        commit: commit,
                        sinceCommitId: sinceCommitId,
                        changes: changes,
                        change: change,
                        pullRequest: pullRequest
                    }),
                    change && _react2.default.createElement(_change2.default, {
                        change: change,
                        fromHash: fromHash,
                        pullRequest: pullRequest,
                        repository: repository,
                        toHash: toHash
                    })
                );
            }
        }]);

        return Changes;
    }(_react.PureComponent);

    exports.default = Changes;
    module.exports = exports['default'];
});