define('bitbucket/internal/next/feature/changes/changes-tree/utils/file-change-status', ['exports', '@atlassian/aui', 'bitbucket/internal/enums'], function (exports, _aui, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getFileChangeStatus = undefined;

    var _changeTypeI18nMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var ADD = _enums.ChangeTypes.ADD,
        COPY = _enums.ChangeTypes.COPY,
        DELETE = _enums.ChangeTypes.DELETE,
        MOVE = _enums.ChangeTypes.MOVE,
        MODIFY = _enums.ChangeTypes.MODIFY,
        RENAME = _enums.ChangeTypes.RENAME,
        UNKNOWN = _enums.ChangeTypes.UNKNOWN;


    var changeTypeI18nMap = (_changeTypeI18nMap = {}, _defineProperty(_changeTypeI18nMap, ADD, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.added', filename);
    }), _defineProperty(_changeTypeI18nMap, COPY, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.copied', filename);
    }), _defineProperty(_changeTypeI18nMap, DELETE, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.removed', filename);
    }), _defineProperty(_changeTypeI18nMap, MOVE, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.moved', filename);
    }), _defineProperty(_changeTypeI18nMap, MODIFY, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.modified', filename);
    }), _defineProperty(_changeTypeI18nMap, RENAME, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.renamed', filename);
    }), _defineProperty(_changeTypeI18nMap, UNKNOWN, function (filename) {
        return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.unknown', filename);
    }), _changeTypeI18nMap);

    var getFileChangeStatus = exports.getFileChangeStatus = function getFileChangeStatus(_ref) {
        var changeType = _ref.changeType,
            hasConflict = _ref.hasConflict,
            filename = _ref.filename;

        if (hasConflict) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.file.status.conflict', filename);
        }

        var i18nGetter = changeTypeI18nMap[changeType] || changeTypeI18nMap[UNKNOWN];

        return i18nGetter(filename);
    };
});