define('bitbucket/internal/next/feature/changes/changes-store', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/selectors', 'bitbucket/internal/util/store/store'], function (exports, _lodash, _redux, _reselect, _navbuilder, _enums, _entity, _restActor, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._transformChangesPaths = exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var store = (0, _store2.default)();
    var APP_NAME = 'CHANGES';

    var MAX_CHANGES = 1000; //TODO should come from server

    var requestTypes = {
        PULL_REQUEST: _enums.Entity.PULL_REQUEST, //Any PR diff, including single commit and iterative
        COMMIT: _enums.Entity.COMMIT, //Commit page diff - TBD
        COMPARE: 'COMPARE' //Compare page diff - TBD
    };

    var getId = function getId(_ref) {
        var path = _ref.path,
            contentId = _ref.contentId,
            fromContentId = _ref.fromContentId;
        return [path, contentId, fromContentId].join('/');
    };

    /* ACTIONS */
    var LOAD_PAGE = 'LOAD_CHANGES';
    var LOAD_PAGE_SUCCESS = 'LOAD_CHANGES_SUCCESS';
    var LOAD_PAGE_FAILURE = 'LOAD_CHANGES_FAILURE';

    var transformChangesPaths = function transformChangesPaths(changes) {
        return changes.map(function (change) {
            return _extends({}, change, {
                path: (0, _lodash.get)(change, 'path.toString'),
                srcPath: (0, _lodash.get)(change, 'srcPath.toString')
            });
        });
    };

    /* ACTORS */
    var actors = [(0, _restActor.restActorForType)(LOAD_PAGE, function (action, state) {
        var requestInfo = getRequestInfo(function () {
            return action;
        })(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        if ((0, _lodash.get)(requestInfo, 'pagingMeta.isLastPage')) {
            throw new Error('Cannot request beyond the last page');
        }

        var start = (0, _lodash.get)(requestInfo, 'pagingMeta.nextPageStart', 0);

        var _action$payload = action.payload,
            commit = _action$payload.commit,
            _action$payload$limit = _action$payload.limit,
            limit = _action$payload$limit === undefined ? (0, _lodash.get)(requestInfo, 'pagingMeta.limit', MAX_CHANGES) : _action$payload$limit,
            pullRequest = _action$payload.pullRequest,
            requestType = _action$payload.requestType,
            sinceCommitId = _action$payload.sinceCommitId;


        var urlBuilder = _navbuilder2.default.rest();

        switch (requestType) {
            case requestTypes.PULL_REQUEST:
                urlBuilder = urlBuilder.pullRequest(pullRequest).changes();

                if (commit) {
                    var sinceId = sinceCommitId ? sinceCommitId : (0, _lodash.get)(commit, 'parents.0.id');

                    urlBuilder = urlBuilder.withParams({
                        changeScope: 'RANGE',
                        untilId: commit.id,
                        sinceId: sinceId
                    });
                }

                //TODO: `unreviewed`
                break;
            //TODO: requestTypes.COMMIT, requestTypes.COMPARE
            default:
                throw new Error('Invalid request type');
        }

        return {
            url: urlBuilder.withParams({ avatarSize: _enums.AvatarSize.SMALL, markup: true, limit: limit, start: start }).build()
        };
    }, {
        successTransform: function successTransform(response) {
            return (0, _lodash.set)(response, 'values', transformChangesPaths(response.values));
        }
    })];

    store.addActors(actors);

    /* REDUCERS */
    var requestTypeKeyProps = _defineProperty({}, requestTypes.PULL_REQUEST, [['pullRequest', _entity.getPullRequestId], 'pullRequest.fromRef.latestCommit', 'pullRequest.toRef.latestCommit', 'commit.id', 'sinceCommitId']);

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.entitiesReducer)({
            loadPageSuccess: [LOAD_PAGE_SUCCESS]
        }, getId),
        requests: (0, _redux.combineReducers)(_defineProperty({}, LOAD_PAGE, (0, _reducers.getRequestPageReducersByType)({
            requestTypeKeyProps: requestTypeKeyProps,
            getId: getId,
            LOAD_PAGE: LOAD_PAGE,
            LOAD_PAGE_FAILURE: LOAD_PAGE_FAILURE,
            LOAD_PAGE_SUCCESS: LOAD_PAGE_SUCCESS
        })))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadPullRequestChanges: function loadPullRequestChanges(_ref2) {
            var pullRequest = _ref2.pullRequest,
                commit = _ref2.commit,
                sinceCommitId = _ref2.sinceCommitId;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.PULL_REQUEST,
                    pullRequest: pullRequest,
                    commit: commit,
                    sinceCommitId: sinceCommitId
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        }
        // TODO: loadCommitChanges, loadCompareChanges
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: getId,
        requestTypeKeyProps: requestTypeKeyProps
    }),
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getEntitiesForRequest = _getSelectorsForApp.getEntitiesForRequest,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getAllFetchedForRequest = _getSelectorsForApp.getAllFetchedForRequest,
        getPagingMetaForRequest = _getSelectorsForApp.getPagingMetaForRequest;

    var getPullRequestChangesPagingMeta = function getPullRequestChangesPagingMeta(requestParamsSelector) {
        return getPagingMetaForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestChanges));
    };

    var selectors = exports.selectors = {
        getPullRequestChanges: function getPullRequestChanges(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestChanges));
        },
        getPullRequestChangesLoading: function getPullRequestChangesLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestChanges));
        },
        getPullRequestChangesAllFetched: function getPullRequestChangesAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestChanges));
        },
        getPullRequestChangeForFilePath: function getPullRequestChangeForFilePath(requestParamsSelector, filePathSelector) {
            return (0, _reselect.createSelector)([getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadPullRequestChanges)), filePathSelector], function (changes, filePath) {
                return changes.find(function (change) {
                    return change.path === filePath;
                });
            });
        },
        getPullRequestChangesFromHash: function getPullRequestChangesFromHash(requestParamsSelector) {
            return (0, _reselect.createSelector)([getPullRequestChangesPagingMeta(requestParamsSelector)], function (_ref3) {
                var fromHash = _ref3.fromHash;
                return fromHash;
            });
        },
        getPullRequestChangesToHash: function getPullRequestChangesToHash(requestParamsSelector) {
            return (0, _reselect.createSelector)([getPullRequestChangesPagingMeta(requestParamsSelector)], function (_ref4) {
                var toHash = _ref4.toHash;
                return toHash;
            });
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
    exports._transformChangesPaths = transformChangesPaths;
});