define('bitbucket/internal/next/feature/changes/changes-scope-selector/commit-single-value/commit-single-value', ['module', 'exports', '@atlaskit/select', 'prop-types', 'react', 'bitbucket/internal/next/widget/icons', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/parse-commit-message', './commit-single-value.less'], function (module, exports, _select, _propTypes, _react, _icons, _reactFunctional, _parseCommitMessage) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _parseCommitMessage2 = _interopRequireDefault(_parseCommitMessage);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    var SingleValue = _select.components.SingleValue;


    var DefaultSingleValue = function DefaultSingleValue(_ref) {
        var label = _ref.label,
            props = _objectWithoutProperties(_ref, ['label']);

        return _react2.default.createElement(
            SingleValue,
            props,
            _react2.default.createElement(
                'span',
                { className: 'commit-single-value-wrapper' },
                _react2.default.createElement(_icons.CommitsIcon, null),
                _react2.default.createElement(
                    'span',
                    { className: 'commit-single-value-label' },
                    label
                )
            )
        );
    };

    function CommitSingleValue(props) {
        var _props$data = props.data,
            message = _props$data.message,
            value = _props$data.value,
            label = _props$data.label;


        if (value === 'DEFAULT_OPTION_VALUE') {
            return _react2.default.createElement(DefaultSingleValue, _extends({}, props, { label: label }));
        }

        var _parseCommitMessage$s = _parseCommitMessage2.default.splitIntoSubjectAndBody(message),
            messageSubject = _parseCommitMessage$s.subject;

        return _react2.default.createElement(
            SingleValue,
            props,
            _react2.default.createElement(
                'span',
                { className: 'commit-single-value-wrapper' },
                _react2.default.createElement(_icons.CommitsIcon, null),
                _react2.default.createElement(
                    'span',
                    { className: 'commit-single-value-label' },
                    messageSubject
                )
            )
        );
    }

    CommitSingleValue.propTypes = {
        value: _propTypes.string,
        label: _propTypes.string,
        message: _propTypes.string
    };

    CommitSingleValue.defaultProps = {
        value: null,
        label: null,
        message: null
    };

    exports.default = (0, _reactFunctional.pure)(CommitSingleValue);
    module.exports = exports['default'];
});