define('bitbucket/internal/next/feature/changes/changes-scope-selector/commit-option/commit-option', ['exports', '@atlaskit/select', 'classnames', 'react', 'react-router-dom', 'bitbucket/internal/next/global.less', 'bitbucket/internal/next/util/react-i18n', 'bitbucket/internal/next/widget/commit-hash', 'bitbucket/internal/next/widget/icons', 'bitbucket/internal/next/widget/merge-lozenge', 'bitbucket/internal/next/widget/tooltip/commit-message-tooltip', 'bitbucket/internal/next/widget/user-avatar', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/dom-event.js', 'bitbucket/internal/util/parse-commit-message', 'bitbucket/internal/widget/time', './commit-option.less'], function (exports, _select, _classnames, _react, _reactRouterDom, _global, _reactI18n, _commitHash, _icons, _mergeLozenge, _commitMessageTooltip, _userAvatar, _reactFunctional, _domEvent, _parseCommitMessage, _time) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.styles = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _commitHash2 = _interopRequireDefault(_commitHash);

    var _mergeLozenge2 = _interopRequireDefault(_mergeLozenge);

    var _commitMessageTooltip2 = _interopRequireDefault(_commitMessageTooltip);

    var _userAvatar2 = _interopRequireDefault(_userAvatar);

    var _domEvent2 = _interopRequireDefault(_domEvent);

    var _parseCommitMessage2 = _interopRequireDefault(_parseCommitMessage);

    var _time2 = _interopRequireDefault(_time);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var Option = _select.components.Option;
    var styles = exports.styles = function styles(base) {
        return _extends({}, base, {
            cursor: 'pointer',
            marginTop: -1,
            borderTop: '1px solid ' + _global.dividerColor,
            borderBottom: '1px solid ' + _global.dividerColor
        });
    };

    var stopLinkNavigation = function stopLinkNavigation(event) {
        if (_domEvent2.default.openInSameTab(event)) {
            event.preventDefault();
        }
    };

    var LabelOption = function LabelOption(_ref) {
        var label = _ref.label,
            url = _ref.url,
            className = _ref.className,
            props = _objectWithoutProperties(_ref, ['label', 'url', 'className']);

        return _react2.default.createElement(
            _reactRouterDom.Link,
            { to: url, className: 'commit-option-link-wrapper', onClick: stopLinkNavigation },
            _react2.default.createElement(
                Option,
                props,
                _react2.default.createElement(
                    'div',
                    { className: className },
                    _react2.default.createElement(_icons.CommitsIcon, null),
                    _react2.default.createElement(
                        'div',
                        { className: 'commit-option-inner' },
                        label
                    )
                )
            )
        );
    };

    function CommitOption(props) {
        var data = props.data,
            isSelected = props.isSelected;
        var message = data.message,
            author = data.author,
            date = data.date,
            hash = data.hash,
            isMergeCommit = data.isMergeCommit,
            label = data.label,
            value = data.value,
            url = data.url,
            isRange = data.isRange;

        var tooltipPosition = 'right';

        var optionClassName = (0, _classnames2.default)('commit-option', {
            'option-selected': isSelected
        });

        if (value === 'DEFAULT_OPTION_VALUE') {
            return _react2.default.createElement(LabelOption, _extends({}, props, { label: label, url: url, className: optionClassName }));
        }

        if (isRange) {
            return _react2.default.createElement(LabelOption, _extends({}, props, { label: label, url: url, className: optionClassName }));
        }

        var _parseCommitMessage$s = _parseCommitMessage2.default.splitIntoSubjectAndBody(message),
            messageSubject = _parseCommitMessage$s.subject,
            messageBody = _parseCommitMessage$s.body;

        var authorName = author.name,
            authorAvatarUrl = author.avatarUrl;


        var mergeIndicator = isMergeCommit ? _react2.default.createElement(
            'span',
            { className: 'metadata-merge-indicator' },
            _react2.default.createElement(_mergeLozenge2.default, { showTooltip: false })
        ) : null;

        var commitAuthor = _react2.default.createElement(_userAvatar2.default, { className: 'metadata-author', userName: authorName, avatarSrc: authorAvatarUrl });
        var commitContent = _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(
                _commitHash2.default,
                { className: 'metadata-hash' },
                hash
            ),
            mergeIndicator
        );

        return _react2.default.createElement(
            _reactRouterDom.Link,
            { to: url, className: 'commit-option-link-wrapper', onClick: stopLinkNavigation },
            _react2.default.createElement(
                _commitMessageTooltip2.default,
                { message: message, position: tooltipPosition, tag: 'div' },
                _react2.default.createElement(
                    Option,
                    props,
                    _react2.default.createElement(
                        'div',
                        { className: optionClassName },
                        _react2.default.createElement(_icons.CommitsIcon, null),
                        _react2.default.createElement(
                            'div',
                            { className: 'commit-option-inner' },
                            _react2.default.createElement(
                                'div',
                                { className: 'message-wrapper' },
                                _react2.default.createElement(
                                    'span',
                                    { className: 'message-subject' },
                                    messageSubject
                                ),
                                messageBody ? _react2.default.createElement(
                                    'span',
                                    { className: 'message-body' },
                                    '- ',
                                    messageBody
                                ) : null
                            ),
                            _react2.default.createElement(
                                'div',
                                { className: 'metadata-wrapper' },
                                _reactI18n.I18n.getText('bitbucket.web.commit.summary', commitAuthor, commitContent),
                                _react2.default.createElement(_time2.default, { unixTime: date, type: 'shortAge', className: 'metadata-date' })
                            )
                        )
                    )
                )
            )
        );
    }

    exports.default = (0, _reactFunctional.pure)(CommitOption);
});