define('bitbucket/internal/next/feature/changes/changes-scope-header/changes-scope-header', ['module', 'exports', 'react', 'react-router-dom', 'bitbucket/util/navbuilder', 'bitbucket/internal/next/util/react-i18n', 'bitbucket/internal/next/widget/commit-hash/commit-hash', 'bitbucket/internal/util/components/react-functional', './changes-scope-header.less'], function (module, exports, _react, _reactRouterDom, _navbuilder, _reactI18n, _commitHash, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _commitHash2 = _interopRequireDefault(_commitHash);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var getPullRequestCommitUrl = function getPullRequestCommitUrl(_ref) {
        var pullRequest = _ref.pullRequest,
            commitId = _ref.commitId;
        return _navbuilder2.default.pullRequest(pullRequest).commit(commitId).build();
    };

    var Header = (0, _reactFunctional.pure)(function (_ref2) {
        var children = _ref2.children;
        return _react2.default.createElement(
            'h4',
            { className: 'changes-scope-header' },
            children
        );
    });

    var ChangesScopeHeader = function (_PureComponent) {
        _inherits(ChangesScopeHeader, _PureComponent);

        function ChangesScopeHeader() {
            _classCallCheck(this, ChangesScopeHeader);

            return _possibleConstructorReturn(this, (ChangesScopeHeader.__proto__ || Object.getPrototypeOf(ChangesScopeHeader)).apply(this, arguments));
        }

        _createClass(ChangesScopeHeader, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    commit = _props.commit,
                    sinceCommitId = _props.sinceCommitId,
                    commits = _props.commits,
                    pullRequest = _props.pullRequest,
                    areCommitsLoading = _props.areCommitsLoading,
                    areChangesLoading = _props.areChangesLoading;

                var isLoading = areCommitsLoading || areChangesLoading;

                if (isLoading) {
                    return null;
                }

                var selectedCommit = commit ? commits.find(function (_ref3) {
                    var id = _ref3.id;
                    return id === commit.id;
                }) : null;

                if (!selectedCommit || sinceCommitId) {
                    return _react2.default.createElement(
                        Header,
                        null,
                        _reactI18n.I18n.getText('bitbucket.web.difftree.header')
                    );
                }

                var commitId = commit.id,
                    message = commit.message,
                    hash = commit.displayId;

                var commitHash = _react2.default.createElement(
                    _commitHash2.default,
                    { message: message },
                    _react2.default.createElement(
                        _reactRouterDom.Link,
                        { to: getPullRequestCommitUrl({ pullRequest: pullRequest, commitId: commitId }) },
                        hash
                    )
                );

                return _react2.default.createElement(
                    Header,
                    null,
                    _reactI18n.I18n.getText('bitbucket.web.difftree.header.commit.html', commitHash)
                );
            }
        }]);

        return ChangesScopeHeader;
    }(_react.PureComponent);

    exports.default = ChangesScopeHeader;
    module.exports = exports['default'];
});