define('bitbucket/internal/next/feature/change/change-lozenge/change-lozenge', ['module', 'exports', '@atlaskit/lozenge', '@atlaskit/tooltip/', '@atlassian/aui', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/components/react-functional'], function (module, exports, _lozenge, _tooltip, _aui, _react, _enums, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lozenge2 = _interopRequireDefault(_lozenge);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _lozengeText, _lozengeAppearance, _tooltipText;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var lozengeText = (_lozengeText = {}, _defineProperty(_lozengeText, _enums.ChangeTypes.ADD, _aui.I18n.getText('bitbucket.web.file.change.type.added')), _defineProperty(_lozengeText, _enums.ChangeTypes.COPY, _aui.I18n.getText('bitbucket.web.file.change.type.copied')), _defineProperty(_lozengeText, _enums.ChangeTypes.DELETE, _aui.I18n.getText('bitbucket.web.file.change.type.deleted')), _defineProperty(_lozengeText, _enums.ChangeTypes.MODIFY, _aui.I18n.getText('bitbucket.web.file.change.type.modified')), _defineProperty(_lozengeText, _enums.ChangeTypes.MOVE, _aui.I18n.getText('bitbucket.web.file.change.type.moved')), _defineProperty(_lozengeText, _enums.ChangeTypes.RENAME, _aui.I18n.getText('bitbucket.web.file.change.type.renamed')), _defineProperty(_lozengeText, _enums.ChangeTypes.UNKNOWN, _aui.I18n.getText('bitbucket.web.file.change.type.unknown')), _lozengeText);

    var lozengeAppearance = (_lozengeAppearance = {}, _defineProperty(_lozengeAppearance, _enums.ChangeTypes.ADD, 'success'), _defineProperty(_lozengeAppearance, _enums.ChangeTypes.COPY, 'inprogress'), _defineProperty(_lozengeAppearance, _enums.ChangeTypes.DELETE, 'removed'), _defineProperty(_lozengeAppearance, _enums.ChangeTypes.MODIFY, 'inprogress'), _defineProperty(_lozengeAppearance, _enums.ChangeTypes.MOVE, 'moved'), _defineProperty(_lozengeAppearance, _enums.ChangeTypes.RENAME, 'moved'), _defineProperty(_lozengeAppearance, _enums.ChangeTypes.UNKNOWN, 'default'), _lozengeAppearance);

    var tooltipText = (_tooltipText = {}, _defineProperty(_tooltipText, _enums.ChangeTypes.COPY, _aui.I18n.getText('bitbucket.web.file.copied.tooltip')), _defineProperty(_tooltipText, _enums.ChangeTypes.MOVE, _aui.I18n.getText('bitbucket.web.file.moved.tooltip')), _defineProperty(_tooltipText, _enums.ChangeTypes.RENAME, _aui.I18n.getText('bitbucket.web.file.renamed.previous.path')), _tooltipText);

    exports.default = (0, _reactFunctional.pure)(function (_ref) {
        var change = _ref.change;
        var path = change.path,
            srcPath = change.srcPath,
            type = change.type;

        var appearance = lozengeAppearance[type] || lozengeAppearance[_enums.ChangeTypes.UNKNOWN];
        var text = lozengeText[type] || lozengeText[_enums.ChangeTypes.UNKNOWN];

        var lozenge = _react2.default.createElement(
            _lozenge2.default,
            { appearance: appearance },
            text
        );

        if (srcPath) {
            return _react2.default.createElement(
                _tooltip2.default,
                {
                    tag: 'span',
                    content: _react2.default.createElement('div', {
                        dangerouslySetInnerHTML: {
                            //TODO: Do path diffing, only show filename on rename, get rid of dangerouslySetInnerHTML
                            __html: (0, _aui.format)(tooltipText[type], srcPath, path)
                        }
                    })
                },
                lozenge
            );
        }

        return lozenge;
    });
    module.exports = exports['default'];
});