define('bitbucket/internal/layout/files/files', ['module', 'exports', 'bitbucket/internal/model/page-state', 'bitbucket/internal/model/path', 'bitbucket/internal/model/revision-reference', 'bitbucket/internal/util/events', 'bitbucket/internal/widget/breadcrumbs/breadcrumbs'], function (module, exports, _pageState, _path, _revisionReference, _events, _breadcrumbs) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _pageState2 = _interopRequireDefault(_pageState);

    var _path2 = _interopRequireDefault(_path);

    var _revisionReference2 = _interopRequireDefault(_revisionReference);

    var _events2 = _interopRequireDefault(_events);

    var _breadcrumbs2 = _interopRequireDefault(_breadcrumbs);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function onReady(pathComponents, atRevision, breadcrumbsSelector, isDirectory) {
        _pageState2.default.setFilePath(new _path2.default(pathComponents));

        var currentRevisionRef = new _revisionReference2.default(atRevision);
        var breadcrumbs = new _breadcrumbs2.default(breadcrumbsSelector);

        _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.breadcrumbs.urlChanged', function (url) {
            if (this === breadcrumbs) {
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.layout.files.urlChanged', this, url);
            }
        });

        /* React to page changes */
        _events2.default.on('bitbucket.internal.DO_NOT_USE.page.*.revisionRefChanged', function (revisionReference) {
            currentRevisionRef = new _revisionReference2.default(revisionReference.toJSON());
            breadcrumbs.update(currentRevisionRef, new _path2.default(_pageState2.default.getFilePath()), isDirectory);
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.page.*.pathChanged', function (path) {
            path = new _path2.default(path);
            _pageState2.default.setFilePath(path);
            breadcrumbs.update(currentRevisionRef, path, isDirectory);
            // For now, isDirectory won't change when path changes cause we don't have push-state
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});