define('bitbucket/internal/feature/repository/filterable-repository-table/filterable-repository-table', ['exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/highlight', 'bitbucket/internal/widget/filterable-entity-table/filterable-entity-table', 'bitbucket/internal/widget/icons/icons'], function (exports, _aui, _classnames, _propTypes, _react, _navbuilder, _avatar, _enums, _analytics, _highlight, _filterableEntityTable, _icons) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.RepositoryRow = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _highlight2 = _interopRequireDefault(_highlight);

    var _filterableEntityTable2 = _interopRequireDefault(_filterableEntityTable);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var ProjectWithAvatar = function ProjectWithAvatar(_ref) {
        var filter = _ref.filter,
            onClick = _ref.onClick,
            project = _ref.project;

        var isNormalProject = project.type === _enums.ProjectType.NORMAL;

        return _react2.default.createElement(
            'span',
            { className: 'project-name' },
            _react2.default.createElement(_avatar.Avatar, {
                avatarSrc: project.avatarUrl,
                size: _enums.AvatarTShirtSize.SMALL,
                isProject: isNormalProject
            }),
            _react2.default.createElement(
                'a',
                {
                    href: _navbuilder2.default.project(project).build(),
                    onClick: onClick ? function () {
                        return onClick(project);
                    } : null
                },
                _react2.default.createElement(_highlight2.default, { text: project.name, query: filter })
            )
        );
    };

    var RepositoryIcon = function RepositoryIcon(_ref2) {
        var origin = _ref2.origin;

        if (origin) {
            return _react2.default.createElement(
                _icons.ForkSmallIcon,
                {
                    className: 'repository-icon',
                    title: _aui.I18n.getText('bitbucket.web.repository.is.a.fork.of', origin.project.name, origin.name)
                },
                _aui.I18n.getText('bitbucket.web.repository.repository.forked')
            );
        }

        return _react2.default.createElement(
            _icons.RepositorySmallIcon,
            { className: 'repository-icon' },
            _aui.I18n.getText('bitbucket.web.repository.repository')
        );
    };

    var PublicLozenge = function PublicLozenge() {
        return _react2.default.createElement(
            'span',
            { className: 'aui-lozenge aui-lozenge-subtle public-lozenge' },
            _aui.I18n.getText('bitbucket.web.repository.public.lozenge')
        );
    };

    /*eslint-disable react/prefer-stateless-function*/

    var RepositoryRow = exports.RepositoryRow = function (_PureComponent) {
        _inherits(RepositoryRow, _PureComponent);

        function RepositoryRow() {
            _classCallCheck(this, RepositoryRow);

            return _possibleConstructorReturn(this, (RepositoryRow.__proto__ || Object.getPrototypeOf(RepositoryRow)).apply(this, arguments));
        }

        _createClass(RepositoryRow, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    filter = _props.filter,
                    focused = _props.focused,
                    onProjectClick = _props.onProjectClick,
                    onRepoClick = _props.onRepoClick,
                    primaryRefCallback = _props.primaryRefCallback,
                    repository = _props.repository,
                    showProject = _props.showProject,
                    showPublic = _props.showPublic;


                return _react2.default.createElement(
                    'tr',
                    { className: (0, _classnames2.default)({ focused: focused }) },
                    _react2.default.createElement(
                        'td',
                        null,
                        showProject ? _react2.default.createElement(ProjectWithAvatar, {
                            filter: filter,
                            project: repository.project,
                            onClick: onProjectClick
                        }) : _react2.default.createElement(RepositoryIcon, repository),
                        _react2.default.createElement(
                            'span',
                            { className: 'repository-name' },
                            _react2.default.createElement(
                                'a',
                                {
                                    href: _navbuilder2.default.project(repository.project).repo(repository).build(),
                                    onClick: onRepoClick ? function () {
                                        return onRepoClick(repository);
                                    } : null,
                                    ref: function ref(el) {
                                        return primaryRefCallback ? primaryRefCallback(el) : null;
                                    }
                                },
                                _react2.default.createElement(_highlight2.default, { text: repository.name, query: filter })
                            )
                        ),
                        showPublic && (repository.public || repository.project.public) && _react2.default.createElement(PublicLozenge, null)
                    )
                );
            }
        }]);

        return RepositoryRow;
    }(_react.PureComponent);

    RepositoryRow.propTypes = {
        focused: _propTypes2.default.bool,
        onProjectClick: _propTypes2.default.func,
        onRepoClick: _propTypes2.default.func,
        primaryRefCallback: _propTypes2.default.func,
        repository: _propTypes2.default.object,
        showProject: _propTypes2.default.bool,
        showPublic: _propTypes2.default.bool
    };
    RepositoryRow.defaultProps = {
        showProject: false,
        showPublic: true
    };

    var FilterableRepositoryTable = function (_FilterableEntityTabl) {
        _inherits(FilterableRepositoryTable, _FilterableEntityTabl);

        function FilterableRepositoryTable() {
            var _ref3;

            var _temp, _this2, _ret;

            _classCallCheck(this, FilterableRepositoryTable);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref3 = FilterableRepositoryTable.__proto__ || Object.getPrototypeOf(FilterableRepositoryTable)).call.apply(_ref3, [this].concat(args))), _this2), _this2.onProjectClick = function (project) {
                var _this2$props = _this2.props,
                    filter = _this2$props.filter,
                    onProjectClick = _this2$props.onProjectClick;


                onProjectClick && onProjectClick(project, filter);
            }, _this2.onRepoClick = function (repository) {
                var _this2$props2 = _this2.props,
                    entities = _this2$props2.entities,
                    filter = _this2$props2.filter,
                    onRepoClick = _this2$props2.onRepoClick;


                onRepoClick && onRepoClick(repository, filter, entities);

                //Legacy event, avoid using
                _analytics2.default.add('repository-list.item.clicked', {
                    'repository.id': repository.id,
                    'project.id': repository.project.id
                });
            }, _this2.row = function (_ref4) {
                var repository = _ref4.item,
                    focused = _ref4.focused,
                    primaryRefCallback = _ref4.primaryRefCallback;
                return _react2.default.createElement(RepositoryRow, {
                    filter: _this2.props.filter,
                    focused: focused,
                    key: repository.id,
                    onProjectClick: _this2.onProjectClick,
                    onRepoClick: _this2.onRepoClick,
                    repository: repository,
                    showProject: _this2.props.showProject,
                    showPublic: _this2.props.showPublic,
                    primaryRefCallback: primaryRefCallback
                });
            }, _temp), _possibleConstructorReturn(_this2, _ret);
        }

        return FilterableRepositoryTable;
    }(_filterableEntityTable2.default);

    FilterableRepositoryTable.propTypes = _extends({}, _filterableEntityTable2.default.propTypes, {
        onProjectClick: _propTypes2.default.func,
        onRepoClick: _propTypes2.default.func,
        showProject: _propTypes2.default.bool,
        showPublic: _propTypes2.default.bool
    });
    FilterableRepositoryTable.defaultProps = _extends({}, _filterableEntityTable2.default.defaultProps, {
        className: 'filterable-repository-table',
        header: function header() {
            return _react2.default.createElement(
                'tr',
                null,
                _react2.default.createElement(
                    'th',
                    null,
                    _aui.I18n.getText('bitbucket.web.repository.col.name')
                )
            );
        },
        lastPageMessage: _aui.I18n.getText('bitbucket.web.repository.allfetched'),
        loadMoreMessage: _aui.I18n.getText('bitbucket.web.repository.loadmore'),
        noItemsMessage: _aui.I18n.getText('bitbucket.web.repository.nonefound'),
        showProject: false,
        showPublic: true,
        filterPlaceholder: _aui.I18n.getText('bitbucket.web.repository.filter.placeholder')
    });
    exports.default = FilterableRepositoryTable;
});