define('bitbucket/internal/feature/pull-request/commits/pull-request-commits', ['module', 'exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/internal/feature/commits/commits-table', 'bitbucket/internal/util/dom-event', 'bitbucket/internal/util/events', 'bitbucket/internal/util/history'], function (module, exports, _aui, _jquery, _lodash, _navbuilder, _commitsTable, _domEvent, _events, _history) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _commitsTable2 = _interopRequireDefault(_commitsTable);

    var _domEvent2 = _interopRequireDefault(_domEvent);

    var _events2 = _interopRequireDefault(_events);

    var _history2 = _interopRequireDefault(_history);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _destroyables = void 0;
    var pullRequestId = void 0;
    var commitsTable = void 0;

    function getCommitsUrlBuilder() {
        var builder = _navbuilder2.default.currentRepo().pullRequest(pullRequestId).commits();

        return builder;
    }

    function init(options) {
        _destroyables = [];
        pullRequestId = options.pullRequest.getId();

        var $table = (0, _jquery2.default)(bitbucket.internal.feature.pullRequest.commits.pullRequestCommits.commits({
            repository: options.repository.toJSON(),
            commitsTableWebSections: options.commitsTableWebSections
        }));

        // HACK: We keep the table out of the DOM until it's fully initialized (for UX reasons).
        // HACK: To avoid multiple pages being loaded because of this, we suspend the commits table, and
        // HACK: resume once the table is in the DOM.
        // HACK: $fakeParent is required because paged-table adds a spinner as a sibling.
        var $fakeParent = (0, _jquery2.default)('<div />').append($table);

        commitsTable = new _commitsTable2.default(getCommitsUrlBuilder, {
            target: $table,
            webSections: options.commitsTableWebSections,
            allCommitsFetchedMessage: AJS.I18n.getText('bitbucket.web.pullrequest.allcommitsfetched'),
            focusFirstRow: true
        });

        // HACK: see note on $fakeParent above.
        (0, _jquery2.default)(options.el).append(commitsTable.$spinner);

        // HACK: see note on $fakeParent above.
        var promise = commitsTable.init({ suspended: true }).done(function () {
            (0, _jquery2.default)(options.el).prepend($fakeParent.children());
            commitsTable.resume();
            commitsTable.bindKeyboardShortcuts();
        });

        _destroyables.push(_events2.default.chainWith((0, _jquery2.default)(document)).on('click', '.commits-table a.commitid', function (e) {
            var commitJSON = (0, _jquery2.default)(e.target).closest('tr').attr('data-commit-json');
            // Analytics event: stash.client.pullRequest.commit.open
            _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.pullRequest.commit.open', this, {
                commitJSON: commitJSON ? JSON.parse(commitJSON) : null,
                pullRequest: options.pullRequest
            });
            // we have enough information to pushState & user hasn't specified to open link in new tab/window
            if (commitJSON && _domEvent2.default.openInSameTab(e)) {
                _history2.default.pushState({
                    commit: JSON.parse(commitJSON)
                }, null, e.target.href);
                e.preventDefault();
            }
            // else let it naturally page pop
        }));

        return promise;
    }

    function reset() {
        _lodash2.default.invokeMap(_destroyables, 'destroy');
        commitsTable.destroy();
        commitsTable = null;
    }

    exports.default = {
        init: init,
        reset: reset
    };
    module.exports = exports['default'];
});