define('bitbucket/internal/feature/discussion/participants-list/participants-list', ['module', 'exports', '@atlassian/aui', 'lodash'], function (module, exports, _aui, _lodash) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _lodash2 = _interopRequireDefault(_lodash);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function ParticipantsList(participants, $list, $container) {
        this.$list = $list;
        this.$container = $container;
        this.participants = participants;

        _lodash2.default.bindAll(this, 'addedParticipantHandler', 'approvalHandler');

        participants.on('change:approved', this.approvalHandler);
        participants.on('add', this.addedParticipantHandler);
    }

    ParticipantsList.prototype.addedParticipantHandler = function (participant) {
        this.$list.append('<li>' + bitbucket.internal.widget.avatarList.avatarList.participantAvatar({
            participant: participant.toJSON(),
            extraClasses: 'participant-item',
            withName: true
        }) + '</li>');

        var $count = this.$container.find('.count');
        if ($count.length) {
            var count = parseInt($count.text(), 10);

            if (count === 1) {
                // Pluralise label
                var $label = this.$container.find('.label');
                $label.text(AJS.I18n.getText('bitbucket.web.discussion.participants.label.plural'));
            }

            $count.text(++count);
        } else {
            this.$container.find('.participants-trigger').prepend(bitbucket.internal.feature.discussion.participantsList.participantsList.participantCount({
                count: 1
            }));
        }

        this.$container.removeClass('hidden');
    };

    ParticipantsList.prototype.approvalHandler = function (participant) {
        var $avatars = this.$list.find(".user-avatar[data-username='" + participant.getUser().getName() + "']");
        $avatars.toggleClass('badge-hidden', !participant.getApproved());
    };

    ParticipantsList.prototype.destroy = function () {
        this.participants.off('add', this.addedParticipantHandler);
        this.participants.off('change:approved', this.approvalHandler);
    };

    exports.default = ParticipantsList;
    module.exports = exports['default'];
});