define('bitbucket/internal/feature/dashboard/reducers/entities/pull-request-suggestions', ['module', 'exports', 'bitbucket/internal/util/store/reducers', '../../actions', '../../util/suggestion-unique-id'], function (module, exports, _reducers, _actions, _suggestionUniqueId) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _suggestionUniqueId2 = _interopRequireDefault(_suggestionUniqueId);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    exports.default = (0, _reducers.reduceByType)({}, _defineProperty({}, _actions.LOAD_PULL_REQUEST_SUGGESTIONS_SUCCESS, function (state, action) {
        // we always throw away the previous PR suggestions so we don't get duplicates listed
        return action.payload.values.reduce(function (suggestionsById, suggestion) {
            suggestionsById[(0, _suggestionUniqueId2.default)(suggestion)] = suggestion;
            return suggestionsById;
        }, {});
    }));
    module.exports = exports['default'];
});