define('bitbucket/internal/feature/dashboard/components/pull-request-table', ['exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/bbui/utils/pull-request-unique-id', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/client-storage', 'bitbucket/internal/widget/icons/icons', '../pull-request-type', './pull-request-row', './pull-request-table-web-section'], function (exports, _aui, _classnames, _propTypes, _react, _spinner, _pullRequestUniqueId, _analytics, _clientStorage, _icons, _pullRequestType, _pullRequestRow, _pullRequestTableWebSection) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.PullRequestTable = exports.PullRequestEmptyState = exports.CountTitleDisplay = exports.LoadMoreButton = undefined;

    var AJS = _interopRequireWildcard(_aui);

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _spinner2 = _interopRequireDefault(_spinner);

    var _pullRequestUniqueId2 = _interopRequireDefault(_pullRequestUniqueId);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _clientStorage2 = _interopRequireDefault(_clientStorage);

    var _pullRequestRow2 = _interopRequireDefault(_pullRequestRow);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _EmptyStateMessage;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var webSections = (0, _pullRequestTableWebSection.getWebSections)();

    var CollapsedCountTooltip = _defineProperty({}, _pullRequestType.CLOSED, AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.closed.tooltip'));

    var EmptyStateMessage = (_EmptyStateMessage = {}, _defineProperty(_EmptyStateMessage, _pullRequestType.REVIEWING, AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.reviewing.empty')), _defineProperty(_EmptyStateMessage, _pullRequestType.CREATED, AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.created.empty')), _defineProperty(_EmptyStateMessage, _pullRequestType.CLOSED, AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.closed.empty')), _EmptyStateMessage);

    var EmptyStateDescription = _defineProperty({}, _pullRequestType.CREATED, AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.created.empty.description'));

    var LoadMoreButton = exports.LoadMoreButton = function LoadMoreButton(_ref) {
        var _onClick = _ref.onClick;
        return _react2.default.createElement(
            'button',
            { className: 'aui-button aui-button-link', type: 'button', onClick: function onClick() {
                    return _onClick();
                } },
            AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.loadmore')
        );
    };

    var CountTitleDisplay = exports.CountTitleDisplay = function CountTitleDisplay(_ref2) {
        var title = _ref2.title,
            collapsedCountTooltip = _ref2.collapsedCountTooltip,
            lozengeDisplayCount = _ref2.lozengeDisplayCount;
        return _react2.default.createElement(
            'span',
            null,
            title,
            _react2.default.createElement(
                'span',
                { className: 'aui-badge', title: collapsedCountTooltip },
                lozengeDisplayCount
            )
        );
    };

    var PullRequestEmptyState = exports.PullRequestEmptyState = function PullRequestEmptyState(_ref3) {
        var message = _ref3.message,
            description = _ref3.description;
        return _react2.default.createElement(
            'div',
            { className: 'pull-request-list-empty-state' },
            _react2.default.createElement(_icons.ApproveIcon, null),
            _react2.default.createElement(
                'p',
                { className: 'pull-request-empty-state-title' },
                message
            ),
            description && _react2.default.createElement(
                'p',
                { className: 'pull-request-empty-state-description' },
                description
            )
        );
    };

    var PullRequestTable = exports.PullRequestTable = function PullRequestTable(_ref4) {
        var pullRequests = _ref4.pullRequests,
            showStateLozenge = _ref4.showStateLozenge,
            _onItemClick = _ref4.onItemClick,
            focusedPullRequest = _ref4.focusedPullRequest,
            focusedPullRequestIndex = _ref4.focusedPullRequestIndex;
        return _react2.default.createElement(
            'table',
            { className: (0, _classnames2.default)('aui table', 'dashboard-pull-requests-table') },
            _react2.default.createElement(
                'thead',
                null,
                _react2.default.createElement(
                    'tr',
                    null,
                    _react2.default.createElement(
                        'th',
                        { className: 'header-summary', scope: 'col', colSpan: '6' },
                        '\xA0'
                    ),
                    _react2.default.createElement(
                        'th',
                        { className: 'reviewers' },
                        AJS.I18n.getText('bitbucket.web.dashboard.pullrequests.heading.reviewers')
                    ),
                    webSections.map(function (section) {
                        return _react2.default.createElement(_pullRequestTableWebSection.WebSectionHeader, { key: section.key, webSection: section });
                    })
                )
            ),
            _react2.default.createElement(
                'tbody',
                null,
                pullRequests.map(function (pullRequest) {
                    return _react2.default.createElement(_pullRequestRow2.default, {
                        key: (0, _pullRequestUniqueId2.default)(pullRequest),
                        focused: (0, _pullRequestUniqueId2.default)(pullRequest) === (0, _pullRequestUniqueId2.default)(focusedPullRequest),
                        focusedPullRequestIndex: focusedPullRequestIndex,
                        pullRequest: pullRequest,
                        onItemClick: function onItemClick(e) {
                            return _onItemClick(e);
                        },
                        webSections: webSections,
                        showStateLozenge: showStateLozenge
                    });
                })
            )
        );
    };

    var PullRequestsTable = function (_Component) {
        _inherits(PullRequestsTable, _Component);

        function PullRequestsTable(props) {
            _classCallCheck(this, PullRequestsTable);

            var _this = _possibleConstructorReturn(this, (PullRequestsTable.__proto__ || Object.getPrototypeOf(PullRequestsTable)).call(this, props));

            // note that `props.type` is expected to be static for the lifetime of the component.
            _this.CLIENT_STORAGE_KEY = _clientStorage2.default.buildKey(['dashboard', 'pull-requests', props.type, 'table', 'collapsed'], 'user');
            _this.state = {
                collapsed: Boolean(props.collapsible) && _clientStorage2.default.getItem(_this.CLIENT_STORAGE_KEY) !== false
            };
            return _this;
        }

        _createClass(PullRequestsTable, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                if (this.props.collapsible) {
                    _analytics2.default.add('dashboard.pullrequest-list.' + this.props.type.toLowerCase() + '.collapsed.initial', {
                        collapsed: this.state.collapsed
                    });
                }
            }
        }, {
            key: 'collapsedDisplay',
            value: function collapsedDisplay(_ref5) {
                var _this2 = this;

                var title = _ref5.title,
                    collapsedCountTooltip = _ref5.collapsedCountTooltip,
                    lozengeDisplayCount = _ref5.lozengeDisplayCount;

                return _react2.default.createElement(
                    'button',
                    {
                        onClick: function onClick(e) {
                            e.preventDefault();
                            _this2.toggleTableCollapsed();
                        },
                        className: 'table-expander',
                        href: '#'
                    },
                    _react2.default.createElement(_icons.ChevronRightIcon, null),
                    title,
                    _react2.default.createElement(
                        'span',
                        { className: 'aui-badge', title: collapsedCountTooltip },
                        lozengeDisplayCount
                    )
                );
            }
        }, {
            key: 'toggleTableCollapsed',
            value: function toggleTableCollapsed() {
                var newCollapsed = !this.state.collapsed;

                this.setState({
                    collapsed: newCollapsed
                });

                _clientStorage2.default.setItem(this.CLIENT_STORAGE_KEY, newCollapsed);
                _analytics2.default.add('dashboard.pullrequest-list.' + this.props.type.toLowerCase() + '.collapsed.toggle', {
                    collapsed: newCollapsed
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    type = _props.type,
                    title = _props.title,
                    pullRequests = _props.pullRequests,
                    loading = _props.loading,
                    lozengeDisplayCount = _props.lozengeDisplayCount,
                    hasMore = _props.hasMore,
                    onLoadMoreClick = _props.onLoadMoreClick,
                    onItemClick = _props.onItemClick,
                    showStateLozenge = _props.showStateLozenge,
                    collapsible = _props.collapsible,
                    focusedPullRequest = _props.focusedPullRequest,
                    focusedPullRequestIndex = _props.focusedPullRequestIndex;

                var button = hasMore ? _react2.default.createElement(LoadMoreButton, { onClick: function onClick() {
                        return onLoadMoreClick();
                    } }) : null;
                var pullRequestCount = pullRequests.length;
                var displayCollapsible = pullRequestCount ? collapsible : false;
                var collapsedCountTooltip = CollapsedCountTooltip[type];
                var collapsed = displayCollapsible && this.state.collapsed;

                return _react2.default.createElement(
                    'div',
                    {
                        className: (0, _classnames2.default)('dashboard-pull-requests-table-container', 'dashboard-pull-requests-table-' + type.toLowerCase(), {
                            collapsed: collapsed,
                            'dashboard-pull-requests-empty': !pullRequestCount
                        }),
                        'aria-hidden': collapsed
                    },
                    _react2.default.createElement(
                        'h4',
                        null,
                        pullRequestCount && displayCollapsible ? this.collapsedDisplay({
                            title: title,
                            collapsedCountTooltip: collapsedCountTooltip,
                            lozengeDisplayCount: lozengeDisplayCount
                        }) : pullRequestCount ? _react2.default.createElement(CountTitleDisplay, {
                            title: title,
                            collapsedCountTooltip: collapsedCountTooltip,
                            lozengeDisplayCount: lozengeDisplayCount
                        }) : title
                    ),
                    pullRequestCount ? _react2.default.createElement(PullRequestTable, {
                        pullRequests: pullRequests,
                        showStateLozenge: showStateLozenge,
                        onItemClick: onItemClick,
                        focusedPullRequest: focusedPullRequest,
                        focusedPullRequestIndex: focusedPullRequestIndex
                    }) : _react2.default.createElement(PullRequestEmptyState, {
                        message: EmptyStateMessage[type],
                        description: EmptyStateDescription[type]
                    }),
                    _react2.default.createElement(
                        'div',
                        { className: 'more-container' },
                        loading ? _react2.default.createElement(_spinner2.default, null) : button
                    )
                );
            }
        }], [{
            key: 'getDerivedStateFromProps',
            value: function getDerivedStateFromProps(_ref6, prevState) {
                var pullRequests = _ref6.pullRequests,
                    focusedPullRequest = _ref6.focusedPullRequest;

                if (!focusedPullRequest || !prevState.collapsed) {
                    return null;
                }
                var focusedId = (0, _pullRequestUniqueId2.default)(focusedPullRequest);
                if (pullRequests.some(function (pr) {
                    return (0, _pullRequestUniqueId2.default)(pr) === focusedId;
                })) {
                    return { collapsed: false };
                }
                return null;
            }
        }]);

        return PullRequestsTable;
    }(_react.Component);

    PullRequestsTable.propTypes = {
        type: _propTypes2.default.string.isRequired,
        title: _propTypes2.default.string.isRequired,
        pullRequests: _propTypes2.default.array.isRequired,
        lozengeDisplayCount: _propTypes2.default.string.isRequired,
        loading: _propTypes2.default.bool,
        hasMore: _propTypes2.default.bool,
        onLoadMoreClick: _propTypes2.default.func.isRequired,
        onItemClick: _propTypes2.default.func.isRequired,
        showStateLozenge: _propTypes2.default.bool,
        collapsible: _propTypes2.default.bool,
        focusedPullRequest: _propTypes2.default.object,
        focusedPullRequestIndex: _propTypes2.default.number.isRequired
    };
    exports.default = PullRequestsTable;
});