define('bitbucket/internal/feature/alerts/containers/alerts', ['exports', '@atlassian/aui', 'react', 'react-redux', '../action-creators', '../components/alerts-empty', '../components/alerts-list', '../selectors'], function (exports, _aui, _react, _reactRedux, _actionCreators, _alertsEmpty, _alertsList, _selectors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Alerts = undefined;

    var AJS = _interopRequireWildcard(_aui);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var Alerts = exports.Alerts = function Alerts(_ref) {
        var alerts = _ref.alerts,
            remove = _ref.remove;

        if (!alerts || alerts.length === 0) {
            return _react2.default.createElement(_alertsEmpty.AlertsEmpty, null);
        }
        var title = AJS.I18n.getText('bitbucket.web.alerts.title');
        return _react2.default.createElement(
            'div',
            { id: 'bitbucket-alerts', className: 'bitbucket-alerts' },
            _react2.default.createElement(_alertsList.AlertsList, { title: title, alerts: alerts, onRemove: remove })
        );
    };

    function mapStateToProps(state) {
        return {
            alerts: (0, _selectors.alertsBySeverity)(state)
        };
    }

    exports.default = (0, _reactRedux.connect)(mapStateToProps, { remove: _actionCreators.remove })(Alerts);
});