define('bitbucket/internal/feature/admin/storage/storage', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/bbui/aui-react/flags', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/timer', './add-store-dialog', './store-item'], function (module, exports, _aui, _propTypes, _react, _navbuilder, _server, _flags, _analytics, _timer, _addStoreDialog, _storeItem) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _flags2 = _interopRequireDefault(_flags);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _addStoreDialog2 = _interopRequireDefault(_addStoreDialog);

    var _storeItem2 = _interopRequireDefault(_storeItem);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var notifications = {
        success: {
            body: _aui.I18n.getText('bitbucket.web.admin.storage.data.store.added.successfully'),
            type: _flags.flagType.SUCCESS,
            id: 'success',
            close: _flags.closeType.AUTO
        }
    };

    var initialState = {
        showDialog: false,
        path: '',
        pathInfo: null,
        saving: false,
        errors: [],
        notification: null
    };

    var Storage = function (_Component) {
        _inherits(Storage, _Component);

        function Storage() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, Storage);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Storage.__proto__ || Object.getPrototypeOf(Storage)).call.apply(_ref, [this].concat(args))), _this), _this.state = _extends({}, initialState, {
                config: _this.props.config
            }), _this.toggleDialog = function () {
                _this.setState(function (prevState) {
                    return _extends({}, initialState, {
                        showDialog: !prevState.showDialog
                    });
                });
            }, _this.fetchStores = function () {
                return (0, _server.rest)({
                    url: _navbuilder2.default.newBuilder(['rest', 'ui', 'admin', 'storage']).build()
                }).done(function (store) {
                    _this.setState({
                        config: store
                    });
                });
            }, _this.validatePath = function (e) {
                e.preventDefault();
                (0, _timer.startTimer)('validation');

                _this.attachStore(_this.state.path, { dryRun: true }).done(function (pathInfo) {
                    _analytics2.default.add('stash.client.storage.dataStore.added', {
                        dryRun: true,
                        time: Math.round((0, _timer.endTimer)('validation')),
                        succeeded: true
                    });

                    _this.setState({
                        errors: [],
                        pathInfo: pathInfo
                    });
                }).fail(function (xhr) {
                    _analytics2.default.add('stash.client.storage.dataStore.added', {
                        dryRun: true,
                        time: Math.round((0, _timer.endTimer)('validation')),
                        succeeded: false
                    });

                    _this.setState({
                        errors: xhr.responseJSON.errors,
                        pathInfo: null
                    });
                });
            }, _this.onInputChange = function (e) {
                _this.setState({
                    path: e.target.value,
                    errors: [],
                    pathInfo: null
                });
            }, _this.createStore = function () {
                (0, _timer.startTimer)('addStore');

                _this.setState({ saving: true });
                _this.attachStore(_this.state.path).done(function () {
                    _this.setState(_extends({}, initialState, {
                        notification: [notifications.success]
                    }));
                    _analytics2.default.add('stash.client.storage.dataStore.added', {
                        dryRun: false,
                        time: Math.round((0, _timer.endTimer)('addStore')),
                        succeeded: true
                    });

                    _this.fetchStores();
                }).fail(function (xhr) {
                    _analytics2.default.add('stash.client.storage.dataStore.added', {
                        dryRun: false,
                        time: Math.round((0, _timer.endTimer)('addStore')),
                        succeeded: false
                    });

                    _this.setState({
                        saving: false,
                        errors: _this.groupErrorsByMessage(xhr.responseJSON.errors)
                    });
                });
            }, _this.attachStore = function (path) {
                var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                    _ref2$dryRun = _ref2.dryRun,
                    dryRun = _ref2$dryRun === undefined ? false : _ref2$dryRun;

                return (0, _server.rest)({
                    url: _navbuilder2.default.newBuilder(['rest', 'ui', 'admin', 'storage', 'attach'], { dryRun: dryRun }).build(),
                    type: _server.method.POST,
                    data: { path: path },
                    statusCode: {
                        400: false, // errors are displayed inline below the input field
                        409: false
                    }
                });
            }, _this.groupErrorsByMessage = function (errors) {
                // Group errors by message - accumulating the cluster nodes that the error applies to in the "nodes" property
                var groupedErrors = {};
                errors.forEach(function (error) {
                    var nodesWithError = groupedErrors[error.message];

                    if (!nodesWithError) {
                        nodesWithError = [];
                        groupedErrors[error.message] = nodesWithError;
                    }

                    if (error.node) {
                        nodesWithError.push(error.node);
                    }
                });

                // Turn groupedErrors back into an array of errors
                return Object.entries(groupedErrors).reduce(function (errors, _ref3) {
                    var _ref4 = _slicedToArray(_ref3, 2),
                        message = _ref4[0],
                        nodes = _ref4[1];

                    errors.push({ message: message, nodes: nodes });
                    return errors;
                }, []);
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(Storage, [{
            key: 'render',
            value: function render() {
                var _this2 = this;

                var _state$config = this.state.config,
                    sharedHome = _state$config.sharedHome,
                    _state$config$additio = _state$config.additional,
                    additional = _state$config$additio === undefined ? [] : _state$config$additio;

                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(
                        'header',
                        { className: 'aui-page-header' },
                        _react2.default.createElement(
                            'div',
                            { className: 'aui-page-header-inner' },
                            _react2.default.createElement(
                                'div',
                                { className: 'aui-page-header-main' },
                                _react2.default.createElement(
                                    'h2',
                                    null,
                                    _aui.I18n.getText('bitbucket.web.admin.storage.heading')
                                )
                            ),
                            this.props.canAddStores && _react2.default.createElement(
                                'div',
                                { className: 'aui-page-header-actions' },
                                _react2.default.createElement(
                                    'button',
                                    {
                                        className: 'aui-button add-data-store-button',
                                        onClick: function onClick() {
                                            return _this2.toggleDialog();
                                        }
                                    },
                                    _aui.I18n.getText('bitbucket.web.admin.storage.add.a.data.store')
                                )
                            )
                        ),
                        _react2.default.createElement(
                            'p',
                            null,
                            _aui.I18n.getText('bitbucket.web.admin.storage.description'),
                            ' ',
                            _react2.default.createElement(
                                'a',
                                { href: bitbucket_help_url('bitbucket.help.storage'), target: '_blank' },
                                _aui.I18n.getText('bitbucket.web.admin.storage.learn.more')
                            )
                        )
                    ),
                    _react2.default.createElement(
                        'section',
                        { className: 'storage-section' },
                        _react2.default.createElement(
                            'h3',
                            { className: 'group-title' },
                            _aui.I18n.getText('bitbucket.web.admin.storage.shared.directory')
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'stores-group' },
                            _react2.default.createElement(_storeItem2.default, { store: sharedHome })
                        )
                    ),
                    additional.length ? _react2.default.createElement(
                        'section',
                        { className: 'storage-section' },
                        _react2.default.createElement(
                            'h3',
                            { className: 'group-title' },
                            _aui.I18n.getText('bitbucket.web.admin.storage.data.stores')
                        ),
                        _react2.default.createElement(
                            'div',
                            { className: 'stores-group' },
                            additional.map(function (store) {
                                return _react2.default.createElement(_storeItem2.default, { key: store.path, store: store });
                            })
                        )
                    ) : null,
                    this.state.showDialog && _react2.default.createElement(_addStoreDialog2.default, {
                        validatePath: this.validatePath,
                        onCloseDialog: this.toggleDialog,
                        onInputChange: this.onInputChange,
                        createStore: this.createStore,
                        pathInfo: this.state.pathInfo,
                        errors: this.state.errors,
                        saving: this.state.saving,
                        path: this.state.path
                    }),
                    this.state.notification && _react2.default.createElement(_flags2.default, {
                        flags: this.state.notification,
                        onClose: function onClose() {
                            return _this2.setState({ notification: null });
                        }
                    })
                );
            }
        }]);

        return Storage;
    }(_react.Component);

    Storage.propTypes = {
        canAddStores: _propTypes2.default.bool,
        config: _propTypes2.default.shape({
            sharedHome: _propTypes2.default.object.isRequired,
            additional: _propTypes2.default.array
        })
    };
    Storage.defaultProps = {
        canAddStores: true
    };
    exports.default = Storage;
    module.exports = exports['default'];
});